/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.deliverynote;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.NumberUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.ImageIcon;

public abstract class DeliveryNoteLayoutBase
extends AbstractFormPageDesc {
    public DeliveryNoteLayoutBase() {
        super(Sending.FormName.deliveryNote);
    }

    @Override
    public String getPrintName() {
        return Services.getText(2000);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("spec.xml");
    }

    @Override
    public double getLineHeight() {
        return 4.5;
    }

    @Override
    public int getLinesPerPage() {
        return 14;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/white.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addCheckboxes(panel, c2, sending, disposables);
    }

    private void addCheckboxes(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        BooleanNode node = sending.getForms().getDeliveryNote().getDescriptionInEnglish();
        this.addCheckBox(disposables, panel, c2, Services.getText(2123), node, 122.0, 10.0);
        node = sending.getForms().getDeliveryNote().getShowAdditianalUnit();
        this.addCheckBox(disposables, panel, c2, Services.getText(739), node, 122.0, 15.0);
        node = sending.getForms().getDeliveryNote().getIdInsteadMark();
        this.addCheckBox(disposables, panel, c2, Services.getText(744), node, 122.0, 20.0);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.renderWeights(sending, goodsItems, dataContext, renderContext);
        this.renderTexts(sending, renderContext);
    }

    private void renderTexts(Sending sending, IRenderContext rc) {
        rc.drawString(30.0, 88.0, Fonts.font14bold, Color.BLACK, this.getText(sending, 2000));
        if (rc.isScreen()) {
            rc.drawString(120.0, 90.0, Fonts.font8, Color.BLACK, this.getText(sending, 2403));
        }
        if (rc.isScreen()) {
            rc.drawString(165.0, 90.0, Fonts.font8, Color.BLACK, this.getText(sending, 2404));
        }
        rc.drawString(30.0, 103.0, Fonts.font8, Color.BLACK, this.getText(sending, 2001));
        rc.drawString(30.0, 107.0, Fonts.font8, Color.BLACK, this.getText(sending, 2401));
        rc.drawString(30.0, 111.0, Fonts.font8, Color.BLACK, this.getText(sending, 2402));
        rc.drawString(120.0, 103.0, Fonts.font8, Color.BLACK, this.getText(sending, 2405));
        rc.drawString(120.0, 107.0, Fonts.font8, Color.BLACK, this.getText(sending, 2406));
        rc.drawString(120.0, 111.0, Fonts.font8, Color.BLACK, this.getText(sending, 2407));
        rc.drawString(40.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2416));
        rc.drawString(40.0, 124.0, Fonts.font8, Color.BLACK, this.getText(sending, 2417));
        rc.drawString(60.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, this.isIdInsteadMark(sending) ? 2412 : 2409));
        rc.drawString(102.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2418));
        rc.drawString(102.0, 124.0, Fonts.font8, Color.BLACK, this.getText(sending, 2419));
        rc.drawString(141.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2411));
    }

    private void renderWeights(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        if (!dataContext.isLastPart()) {
            return;
        }
        int fractionDigits = goodsItems.getTotalNetMass().getValue() < 1000.0 ? 3 : 0;
        String gross = NumberUtil.format(fractionDigits, goodsItems.getTotalGrossMass().getValue());
        String net = NumberUtil.format(fractionDigits, goodsItems.getTotalNetMass().getValue());
        renderContext.drawString(30.0, 206.0, Fonts.font8bold, Color.BLACK, this.getText(sending, 730));
        renderContext.drawString(60.0, 206.0, Fonts.font8bold, Color.BLACK, gross);
        renderContext.drawString(30.0, 211.0, Fonts.font8bold, Color.BLACK, this.getText(sending, 731));
        renderContext.drawString(60.0, 211.0, Fonts.font8bold, Color.BLACK, net);
    }

    protected void addConsignor(Sending sending, IRenderContext renderContext, double x, double y, boolean showLabel) {
        if (showLabel) {
            renderContext.drawString(x, y - 18.0, Fonts.font14bold, Color.BLACK, this.getText(sending, 735));
        }
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignor().getAddress();
        renderer.render(renderContext, x, y, Fonts.font11);
    }

    protected void addConsignee(Sending sending, IRenderContext renderContext, double x, double y, boolean showLabel) {
        if (showLabel) {
            renderContext.drawString(x, y - 18.0, Fonts.font14bold, Color.BLACK, this.getText(sending, 736));
        }
        AddressRenderer renderer = sending.getDeliveryAddress().getAddress();
        renderer.render(renderContext, x, y, Fonts.font11);
    }

    protected void renderTextField(Sending sending, IRenderContext renderContext, double x, double y) {
        if (renderContext.isScreen()) {
            return;
        }
        String text = sending.getForms().getDeliveryNote().getTextBesideConsignee().getValue();
        renderContext.drawStringWrap(x, y, 60.0, Fonts.font10, Color.BLACK, text);
    }

    protected void addTextBesideConsignee(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2, double x, double y) {
        StringPm countryPanelPm = new StringPm(sending.getForms().getDeliveryNote().getTextBesideConsignee());
        disposables.add(countryPanelPm);
        StringArea countryPanel = new StringArea(countryPanelPm, 8);
        countryPanel.getTextArea().setFont(c2.getFont(Fonts.font10));
        countryPanel.setBounds(new Rectangle(c2.px(x), c2.py(y), c2.px(60.0), c2.py(36.0)));
        panel.add(countryPanel);
    }

    private String getText(Sending sending, int id) {
        if (sending.getForms().getDeliveryNote().getDescriptionInEnglish().getValue().booleanValue()) {
            return Services.get(ITextService.class).getText(ITextService.Language.en, id);
        }
        return Services.getText(id);
    }

    private boolean isIdInsteadMark(Sending sending) {
        return sending.getForms().getDeliveryNote().getIdInsteadMark().getPrimitiveValue();
    }
}

