/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.emergency;

import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.forms.emergency.ItemRenderer;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.disposable.Disposables;
import java.net.URL;
import javax.swing.ImageIcon;

public class EmergencyItems
extends AbstractFormPageDesc {
    public EmergencyItems() {
        super(Sending.FormName.emergency);
    }

    @Override
    public String getPrintName() {
        return Services.getText(2100);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("items.xml");
    }

    @Override
    public String getGuiName() {
        return Services.getText(2102);
    }

    @Override
    public String getId() {
        return "emergencyItems";
    }

    @Override
    public double getLineHeight() {
        return 53.0;
    }

    @Override
    public int getLinesPerPage() {
        return 4;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/white.png");
    }

    @Override
    public boolean carryOverIsLineItem() {
        return false;
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        ItemRenderer renderer = new ItemRenderer(renderContext);
        if (!dataContext.isFirstPart()) {
            renderer.print(0.0, -7.0, Services.getText(2103) + " " + dataContext.getCurrentPage() + " / " + dataContext.getPageCount());
        }
        for (int i2 = dataContext.from(); i2 < dataContext.to(); ++i2) {
            this.render(goodsItems.getGoodsItems().get(i2), renderer);
            renderer.next();
        }
    }

    private void render(GoodsItem item, ItemRenderer r) {
        r.printHorizontalLine();
        r.print(0.0, 0.0, Fonts.font10bold, item.getGoodsData().getTraderItemID().getStringValue());
        int y = 0;
        r.print(120.0, (double)y, Fonts.font10bold, item.getGoodsData().getCommodityCode().getStringValue());
        IntegralNode key = item.getGoodsData().getStatisticalCode();
        if (key.isInitialized()) {
            r.print(140.0, y, key.getStringValue());
        }
        y = 5;
        r.print(0.0, (double)y, 168.0, item.getGoodsData().getDescriptionShort().getStringValue());
        y = 10;
        r.print(0.0, y, item.getGoodsData().getCommercialGood().getValue().getDesc());
        r.print(100.0, y, Services.getText(1284) + ":");
        r.print(120.0, y, item.getGoodsData().getCustomsClearanceType().getValue().getDesc());
        y = 15;
        r.print(0.0, y, Services.getText(1290) + ":");
        r.print(25.0, y, item.getGoodsData().getNetMass().getStringValue());
        r.print(50.0, y, Services.getText(1291) + ":");
        r.print(75.0, y, item.getGoodsData().getGrossMass().getStringValue());
        r.print(100.0, y, Services.getText(1294) + ":");
        r.print(120.0, y, item.getGoodsData().getStatisticalValueChf().getStringValue());
        y = 20;
        r.print(0.0, y, Services.getText(1265) + ":");
        r.print(50.0, y, Services.getText(1295) + ":");
        r.print(75.0, y, item.getGoodsData().getAdditionalUnit().getStringValue());
        y = 25;
        String packaging = item.getGoodsData().getPackagingType().getValue().getDesc() + ", " + String.valueOf(item.getGoodsData().getQuantity()) + ", " + String.valueOf(item.getGoodsData().getPackagingReferenceNumber());
        r.print(0.0, y, packaging);
        y = 32;
        r.print(0.0, y, Services.getText(1251) + ":");
        r.print(75.0, y, item.getPermits().getPermitObligation().getValue().getDesc());
        y = 37;
        r.print(0.0, y, Services.getText(1252) + ":");
        r.print(75.0, y, item.getNonCustomLaws().getNonCustomsLawObligation().getValue().getDesc());
        y = 42;
        if (item.getGoodsData().getRefundType().isInitialized()) {
            r.print(0.0, y, Services.getText(1261) + ":");
            String text = item.getGoodsData().getRefundType().getValue().getDesc() + ", " + item.getGoodsData().getVOCQuantity().getStringValue();
            r.printWrap(75.0, y, 95.0, Fonts.font10, text);
        }
    }
}

