/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.eur1;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.forms.Eur1;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.FormConst;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.ui.gui.control.DateField;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.img.ScaledPdfImage;
import ch.transsoft.edec.ui.pm.model.DatePm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class Eur1Front
extends AbstractFormPageDesc {
    private ScaledPdfImage eur1Front;
    private static final String BACKGROUND_PDF = "icon/forms/eur1_front.pdf";
    private static final double gap1 = 27.5;
    private static final int REMARKS_X = 119;
    private static final int REMARKS_Y = 89;
    private static final int REMARKS_WIDTH = 85;
    private static final int REMARKS_HEIGHT = 21;

    private static ScaledPdfImage getBackgroundPdfImage(double zoomScale) {
        return IconLoader.getPdfImg(BACKGROUND_PDF, FormConst.SCALE_FACTOR, zoomScale);
    }

    public Eur1Front() {
        super(Sending.FormName.eur1);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("eur1_front.xml");
    }

    @Override
    public String getGuiName() {
        return Services.getText(795);
    }

    @Override
    public String getPrintName() {
        return Services.getText(793);
    }

    @Override
    public String getId() {
        return "eur1_front";
    }

    @Override
    public double getLineHeight() {
        return 5.0;
    }

    @Override
    public int getLinesPerPage() {
        return 19;
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel pageContentPanel, IUnitConverter c2) {
        this.addChooseConsigneeAddressMode(sending, pageContentPanel, c2, disposables);
        this.addFormChooser(disposables, sending, pageContentPanel, c2);
        this.addRemarks(disposables, sending, pageContentPanel, c2);
        this.addCheckboxForItemDescriptionLanguageSelection(pageContentPanel, c2, sending, disposables);
        this.addEur1NumberInfo(pageContentPanel, c2);
        this.addField10Info(pageContentPanel, c2);
        this.addOrderFormsLink(pageContentPanel, c2);
        this.addDateAndPlace(disposables, sending, pageContentPanel, c2);
    }

    @Override
    public void addStaticControls(JPanel panel, IUnitConverter c2) {
        this.addBackgroundImage(panel, c2);
    }

    private void addBackgroundImage(JPanel panel, IUnitConverter c2) {
        if (this.eur1Front == null || !this.eur1Front.scaleEquals(c2.getZoom())) {
            this.eur1Front = Eur1Front.getBackgroundPdfImage(c2.getZoom());
        }
        JLabel label = new JLabel(new ImageIcon(this.eur1Front.getImage()));
        label.setOpaque(true);
        label.setSize(label.getPreferredSize());
        label.setLocation(c2.px(0.0), c2.py(0.0));
        panel.add(label);
    }

    private void addOrderFormsLink(PageContentPanel panel, IUnitConverter c2) {
        this.addLinkedLabel(panel, c2, Services.getText(799), Services.getText(798), 113.0, 6.5);
    }

    private void addDateAndPlace(Disposables disposables, Sending sending, PageContentPanel pageContentPanel, IUnitConverter c2) {
        int X0_PLACE = 142;
        int Y0_PLACE = 269;
        int X0_DATE = 183;
        int YO_DATE = 269;
        int WIDTH_PLACE = 40;
        int WIDTH_DATE = 22;
        int HEIGHT_FIELD = 5;
        StringPm placePm = new StringPm(sending.getForms().getEur1().getPlace());
        disposables.add(placePm);
        StringField place = this.addStringField(placePm);
        pageContentPanel.add(place);
        place.setFont(c2.getFont(Fonts.font9));
        place.setBounds(new Rectangle(c2.px(X0_PLACE), c2.py(Y0_PLACE), c2.px(WIDTH_PLACE), c2.py(HEIGHT_FIELD)));
        DatePm datePm = new DatePm(sending.getForms().getEur1().getDate());
        disposables.add(datePm);
        DateField date = new DateField(datePm);
        pageContentPanel.add(date);
        date.setFont(c2.getFont(Fonts.font9));
        date.setBounds(new Rectangle(c2.px(X0_DATE), c2.py(YO_DATE), c2.px(WIDTH_DATE), c2.py(HEIGHT_FIELD)));
    }

    private void addCheckboxForItemDescriptionLanguageSelection(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        BooleanNode node = sending.getForms().getEur1().getDescriptionInEnglishFront();
        this.addCheckBox(disposables, panel, c2, Services.getText(797), node, 105.0, 123.0);
    }

    private void addEur1NumberInfo(PageContentPanel panel, IUnitConverter c2) {
        this.addInfoIcon(panel, c2, 193, true, 202.4, 16.0, 16);
    }

    private void addField10Info(PageContentPanel panel, IUnitConverter c2) {
        this.addInfoIcon(panel, c2, 493, true, 182.1, 117.5, 16);
    }

    private void addRemarks(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        StringPm remarksPm = new StringPm(sending.getForms().getEur1().getRemarks());
        disposables.add(remarksPm);
        StringArea eur1Remarks = this.addStringArea(panel, remarksPm);
        eur1Remarks.getTextArea().setFont(c2.getFont(Fonts.font9));
        eur1Remarks.setBounds(new Rectangle(c2.px(119.0), c2.py(89.0), c2.px(85.0), c2.py(21.0)));
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton cumulation = this.addRadioButton(c2, radioGroup, 0.0, 0.0, "Cumulation applied with", c2.getFont(Fonts.font8));
        JRadioButton noCumulation = this.addRadioButton(c2, radioGroup, 0.0, 0.0, "No cumulation applied.", c2.getFont(Fonts.font8));
        StringPm countryPm = new StringPm(sending.getForms().getEur1().getCumulationCountry());
        disposables.add(countryPm);
        StringField country = this.addStringField(countryPm);
        country.setFont(c2.getFont(Fonts.font9));
        this.connectRadio(disposables, null, sending.getForms().getEur1().getCumulationApplied(), cumulation, noCumulation);
        JPanel eurMedCumulationPanel = new JPanel();
        eurMedCumulationPanel.setBounds(c2.px(117.0), c2.px(86.0), c2.px(88.0), c2.py(22.0));
        eurMedCumulationPanel.setOpaque(false);
        eurMedCumulationPanel.setLayout(new MigLayout("", "[][]", "[][]"));
        eurMedCumulationPanel.add(cumulation);
        eurMedCumulationPanel.add((Component)country, "push, growx, wrap");
        eurMedCumulationPanel.add(noCumulation);
        panel.add(eurMedCumulationPanel);
        this.addFormTypeListener(disposables, sending, eur1Remarks, eurMedCumulationPanel);
    }

    private void addFormTypeListener(Disposables disposables, Sending sending, StringArea remarks, JPanel cumulation) {
        this.setEur1(this.isEur1(sending), remarks, cumulation);
        disposables.add(sending.getForms().getEur1().getEur1OrMed().addChangeListener((source, info) -> this.setEur1(this.isEur1(sending), remarks, cumulation)));
    }

    private boolean isEur1(Sending sending) {
        return sending.getForms().getEur1().getEur1OrMed().getIntValue() == 0;
    }

    private void setEur1(boolean eur1, StringArea remarks, JPanel cumulation) {
        remarks.setVisible(eur1);
        cumulation.setVisible(!eur1);
    }

    private void addFormChooser(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        Font font = c2.getFont(Fonts.font12bold);
        JRadioButton type1 = this.addRadioButton(panel, c2, radioGroup, 145.0, 5.0, Services.getText(1305), font);
        JRadioButton type2 = this.addRadioButton(panel, c2, radioGroup, 180.0, 5.0, Services.getText(1306), font);
        this.connectRadio(disposables, null, sending.getForms().getEur1().getEur1OrMed(), type1, type2);
    }

    private void addChooseConsigneeAddressMode(Sending sending, PageContentPanel panel, IUnitConverter c2, Disposables disposables) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, radioGroup, 81.5, 65.0, Services.getText(788));
        JRadioButton mode2 = this.addRadioButton(panel, c2, radioGroup, 81.5, 70.0, Services.getText(789));
        JRadioButton mode3 = this.addRadioButton(panel, c2, radioGroup, 81.5, 75.0, Services.getText(794));
        this.connectRadio(disposables, null, sending.getForms().getEur1().getConsigneeAddressMode(), mode1, mode2, mode3);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.addLinesAndGrossMassTotal(goodsItems, dataContext, renderContext);
        this.addConsignor(sending, renderContext);
        this.addConsignee(sending, renderContext);
        this.renderFormTitle(sending, renderContext);
        this.renderRemarks(sending, renderContext);
        this.renderNumberForMail(sending, renderContext);
        this.renderDateAndPlace(sending, renderContext);
    }

    private void renderDateAndPlace(Sending sending, IRenderContext renderContext) {
        if (renderContext.isScreen()) {
            return;
        }
        if (renderContext.getCopyNumber() > 1) {
            return;
        }
        renderContext.drawStringCut(142.0, 269.0, 40.0, Fonts.font9, Color.BLACK, sending.getForms().getEur1().getPlace().getValue());
        renderContext.drawStringCut(183.0, 269.0, 22.0, Fonts.font9, Color.BLACK, sending.getForms().getEur1().getDate().getStringValue());
    }

    private void renderNumberForMail(Sending sending, IRenderContext renderContext) {
        if (renderContext.isEmailAttachment()) {
            renderContext.drawString(148.0, 14.7, Fonts.font12, Color.BLACK, sending.getForms().getEur1().getEur1Number().getValue());
        }
    }

    private void renderRemarks(Sending sending, IRenderContext rc) {
        if (rc.isScreen()) {
            return;
        }
        Eur1 eur1 = sending.getForms().getEur1();
        if (this.isEur1(sending)) {
            String text = eur1.getRemarks().getValue();
            rc.drawStringWrap(119.0, 89.0, 85.0, Fonts.font9, Color.BLACK, text);
        } else if (sending.getForms().getEur1().getCumulationApplied().getIntValue() == 0) {
            Fonts font = Fonts.font9;
            String cumulationCountry = this.cropTextToLength(rc, font, eur1.getCumulationCountry().getValue(), 50.0f);
            rc.drawString(119.0, 92.0, font, Color.BLACK, "x");
            rc.drawString(150.0, 92.0, font, Color.BLACK, cumulationCountry);
        } else {
            rc.drawString(119.0, 101.0, Fonts.font9, Color.BLACK, "x");
        }
    }

    private String cropTextToLength(IRenderContext rc, Fonts font, String text, float maxLength) {
        while (rc.getTextBlockSize(font, text) > (double)maxLength && text.length() > 1) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private void renderFormTitle(Sending sending, IRenderContext rc) {
        if (rc.isScreen()) {
            Font font = new Font("Verdana", 1, 13);
            String text = this.isEur1(sending) ? "EUR.1" : "EUR-MED";
            rc.drawString(116.5, 13.5, 0, font, new Color(100, 100, 100), text);
            rc.drawString(142.0, 13.5, 0, font, new Color(100, 100, 100), "N\u00b0");
            rc.drawString(0.0, 0.0, 0, font, Color.black, "");
        }
    }

    private void addConsignee(Sending sending, IRenderContext renderContext) {
        int addressMode = sending.getForms().getEur1().getConsigneeAddressMode().getIntValue();
        if (addressMode == 2) {
            return;
        }
        AddressRenderer renderer = addressMode == 0 ? sending.getGoodsDeclaration().getConsignee().getAddress() : sending.getGoodsDeclaration().getDelivery().getAddress();
        renderer.render(renderContext, 27.5, 55.0, Fonts.font9);
    }

    private void addConsignor(Sending sending, IRenderContext renderContext) {
        Consignor consignor = sending.getGoodsDeclaration().getConsignor();
        AddressRenderer renderer = consignor.getAddress();
        renderer.render(renderContext, 27.5, 21.0, Fonts.font9);
    }

    private void addLinesAndGrossMassTotal(ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        double line1y = (double)dataContext.getLineCount() * this.getLineHeight() + 131.0;
        renderContext.drawLine(27.0, line1y, 207.0, line1y, 1.0, Color.BLACK);
        DecimalNode totalGrossMass = goodsItems.getTotalGrossMass(0, dataContext.to());
        renderContext.drawStringRightAligned(180.0, line1y, Fonts.font9, Color.BLACK, totalGrossMass.toString());
        renderContext.drawLine(27.0, line1y += 6.0, 207.0, line1y, 1.0, Color.BLACK);
        renderContext.drawLine(27.0, line1y, 207.0, 234.9, 1.0, Color.BLACK);
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getPdfIcon(BACKGROUND_PDF);
    }

    @Override
    public String getUnitName(int units) {
        return units == 1 ? Services.getText(791) : Services.getText(792);
    }

    @Override
    public int getNumberOfCopies() {
        return 3;
    }
}

