/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.list;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.border.EmptyBorder;

public class ItemListFormFront
extends AbstractFormPageDesc {
    public ItemListFormFront() {
        super(Sending.FormName.itemListForm);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("ItemListForm.xml");
    }

    @Override
    public String getGuiName() {
        return Services.getText(970);
    }

    @Override
    public String getId() {
        return "itemListFormFront";
    }

    @Override
    public double getLineHeight() {
        return 5.0;
    }

    @Override
    public int getLinesPerPage() {
        return 30;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/white.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.renderFormInfo(panel, c2);
    }

    private void renderFormInfo(PageContentPanel panel, IUnitConverter c2) {
        Label label = this.addLabel(panel, c2, Fonts.font8, Services.getText(986), 25.0, 10.0, 160, 10);
        label.setBackground(new Color(250, 230, 170));
        label.setOpaque(true);
        int border = c2.px(1.166);
        label.setBorder(new EmptyBorder(border, border, border, border));
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.addConsignor(sending, renderContext, 25.0, 45.0, false);
        this.addConsignee(sending, renderContext, 120.0, 45.0, false);
        this.renderDate(sending, renderContext);
        this.renderPageNumber(renderContext, dataContext);
        this.renderTotals(goodsItems, renderContext, dataContext);
    }

    public void renderTotals(ItemList goodsItems, IRenderContext renderContext, IDataContext dataContext) {
        if (!dataContext.isLastPart()) {
            return;
        }
        double line1y = (double)dataContext.getLineCount() * this.getLineHeight() + 131.0;
        renderContext.drawLine(25.0, line1y, 185.0, line1y, 0.5, Color.BLACK);
        DecimalNode totalNetMass = goodsItems.getTotalNetMass();
        DecimalNode totalValue = goodsItems.getTotalStatisticalValue();
        DecimalNode totalAdditionalUnit = goodsItems.getTotalAdditionalUnit();
        StringNode totalCurrency = goodsItems.getTotalCurrency();
        renderContext.drawStringRightAligned(137.0, line1y, Fonts.font8, Color.BLACK, totalAdditionalUnit.toString());
        renderContext.drawStringRightAligned(157.0, line1y, Fonts.font8, Color.BLACK, totalNetMass.toString());
        renderContext.drawStringRightAligned(177.0, line1y, Fonts.font8, Color.BLACK, totalValue.toString());
        renderContext.drawString(178.0, line1y, Fonts.font8, Color.BLACK, totalCurrency.getValue());
    }

    private void renderPageNumber(IRenderContext renderContext, IDataContext dataContext) {
        String pageNumber = Services.getText(980) + " " + dataContext.getCurrentPage() + " " + Services.getText(981) + " " + dataContext.getPageCount();
        renderContext.drawString(25.0, 96.0, Fonts.font8, Color.BLACK, pageNumber);
    }

    private void renderDate(Sending sending, IRenderContext renderContext) {
        String stringValue = Services.getText(982) + " " + sending.getCreationDate().getStringValue();
        renderContext.drawString(120.0, 96.0, Fonts.font8, Color.BLACK, stringValue);
    }

    protected void addConsignor(Sending sending, IRenderContext renderContext, double x, double y, boolean showLabel) {
        if (showLabel) {
            renderContext.drawString(x, y - 18.0, Fonts.font12bold, Color.BLACK, Services.getText(735));
        }
        Consignor consignor = sending.getGoodsDeclaration().getConsignor();
        Declarant declarant = sending.getGoodsDeclaration().getDeclarant();
        AddressRenderer renderer = consignor.getAddress();
        renderer.addLine("");
        if (declarant.getDeclarantName().isInitialized()) {
            renderer.addLine(Services.getText(983) + " " + sending.getGoodsDeclaration().getDeclarant().getDeclarantName().getValue());
        }
        if (consignor.getPhone().isInitialized()) {
            renderer.addLine(Services.getText(984) + " " + consignor.getPhone().getValue());
        }
        if (consignor.getVatNumber().isInitialized()) {
            renderer.addLine(Services.getText(985) + " " + consignor.getVatNumber().getValue());
        }
        renderer.render(renderContext, x, y, Fonts.font8);
    }

    protected void addConsignee(Sending sending, IRenderContext renderContext, double x, double y, boolean showLabel) {
        if (showLabel) {
            renderContext.drawString(x, y - 18.0, Fonts.font12bold, Color.BLACK, Services.getText(736));
        }
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignee().getAddress();
        renderer.render(renderContext, x, y, Fonts.font8);
    }
}

