/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.spedi;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.forms.Spedi;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.Carrier;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.editor.gui.controls.BooleanField;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class SpediFront
extends AbstractFormPageDesc {
    private static final Fonts font = Fonts.font9;
    private static final double gap0 = 25.0;
    private static final double gap1 = 7.0;
    private static final double gap2 = 110.0;
    private static final double gap10 = 17.0;
    private static final double gap11 = 5.0;
    private StringField referenceText;
    private StringPm referencePm;
    private StringPm declarantPm;

    public SpediFront() {
        super(Sending.FormName.spedi);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("spedi.xml");
    }

    @Override
    public String getGuiName() {
        return Services.getText(750);
    }

    @Override
    public String getId() {
        return "spedi";
    }

    @Override
    public double getLineHeight() {
        return 4.0;
    }

    @Override
    public int getLinesPerPage() {
        return 0;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/white.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addCheckboxes(panel, c2, sending, disposables);
        this.addTitleType(disposables, sending, panel, c2);
        this.addGoodsType(disposables, sending, panel, c2);
        this.addDeliveryMode(disposables, sending, panel, c2);
        this.addForwarding(disposables, sending, panel, c2);
        this.addCleared(disposables, sending, panel, c2);
        this.addTaxed(disposables, sending, panel, c2);
        this.addInsurance(disposables, sending, panel, c2);
        this.addReferenceControls(disposables, sending, panel, c2);
    }

    private void addReferenceControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.referencePm = new StringPm(sending.getForms().getSpedi().getFooterReference());
        disposables.add(this.referencePm);
        this.declarantPm = new StringPm(sending.getGoodsDeclaration().getDeclarant().getDeclarantName());
        disposables.add(this.declarantPm);
        this.referenceText = new StringField();
        this.referenceText.setFont(c2.getFont(Fonts.font10));
        panel.add(this.referenceText);
        this.referenceText.setBounds(c2.px(130.0), c2.py(249.0), c2.px(50.0), c2.py(5.5));
        BooleanNode declarantAsReference = sending.getForms().getSpedi().getDeclarantAsReference();
        BooleanField checkbox = this.addCheckBox(disposables, panel, c2, "", declarantAsReference, 180.0, 249.0);
        checkbox.setToolTipText("Deklarant-Name aus Kopfdaten verwenden");
        disposables.add(declarantAsReference.addChangeListener((source, info) -> this.updateReference(sending)));
        this.updateReference(sending);
    }

    private void updateReference(Sending sending) {
        if (sending.getForms().getSpedi().getDeclarantAsReference().getValue().booleanValue()) {
            this.referenceText.setModel(this.declarantPm);
            this.referenceText.setReadOnly(true);
        } else {
            this.referenceText.setModel(this.referencePm);
            this.referenceText.setReadOnly(false);
        }
    }

    private void addCheckboxes(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        BooleanNode node = sending.getForms().getSpedi().getSpediInEnglish();
        this.addCheckBox(disposables, panel, c2, Services.getText(2317), node, 110.0, 11.0);
        disposables.add(node.addChangeListener((source, info) -> panel.reCreateUi()));
    }

    private void addTitleType(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton type1 = this.addRadioButton(panel, c2, radioGroup, 25.0, 1.0, this.getText(sending, 750));
        JRadioButton type2 = this.addRadioButton(panel, c2, radioGroup, 55.0, 1.0, this.getText(sending, 751));
        JRadioButton type3 = this.addRadioButton(panel, c2, radioGroup, 85.0, 1.0, this.getText(sending, 752));
        this.connectRadio(disposables, null, sending.getForms().getSpedi().getTitleType(), type1, type2, type3);
    }

    private void addGoodsType(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton type1 = this.addRadioButton(panel, c2, radioGroup, 1.0, 130.0, Services.getText(753));
        JRadioButton type2 = this.addRadioButton(panel, c2, radioGroup, 1.0, 134.0, Services.getText(754));
        this.connectRadio(disposables, null, sending.getForms().getSpedi().getGoodsType(), type1, type2);
        StringPm carnetAtaNumber = new StringPm(sending.getForms().getSpedi().getCarnetATAnumber());
        disposables.add(carnetAtaNumber);
        StringField carnetATAnumber = new StringField(carnetAtaNumber);
        Font insuranceFont = c2.getFont(Fonts.font11);
        carnetATAnumber.setFont(insuranceFont);
        panel.add(carnetATAnumber);
        carnetATAnumber.setBounds(c2.px(39.0), c2.py(138.5), c2.px(50.0), c2.py(5.0));
        this.updateInsuranceState(sending, carnetATAnumber);
        ActionListener insuranceListener = e2 -> this.updateInsuranceState(sending, carnetATAnumber);
        type1.addActionListener(insuranceListener);
        type2.addActionListener(insuranceListener);
    }

    private void updateInsuranceState(Sending sending, StringField carnetATAnumber) {
        SwingUtilities.invokeLater(() -> carnetATAnumber.setVisible(sending.getForms().getSpedi().getGoodsType().getIntValue() == 1));
    }

    private void addForwarding(Disposables disposables, final Sending sending, PageContentPanel panel, IUnitConverter c2) {
        double gap = 4.0;
        double x1 = 117.0;
        double x2 = 137.0;
        double x3 = 157.0;
        double y = 92.0;
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton f1 = this.addRadioButton(panel, c2, radioGroup, 117.0, 92.0, this.getText(sending, 755));
        JRadioButton f2 = this.addRadioButton(panel, c2, radioGroup, 117.0, 96.0, this.getText(sending, 756));
        JRadioButton f3 = this.addRadioButton(panel, c2, radioGroup, 137.0, 92.0, this.getText(sending, 757));
        JRadioButton f4 = this.addRadioButton(panel, c2, radioGroup, 137.0, 96.0, this.getText(sending, 758));
        JRadioButton f5 = this.addRadioButton(panel, c2, radioGroup, 157.0, 92.0, this.getText(sending, 759));
        final JRadioButton f6 = this.addRadioButton(panel, c2, radioGroup, 157.0, 96.0, "");
        this.connectRadio(disposables, radioGroup, sending.getForms().getSpedi().getForwarding(), f1, f2, f3, f4, f5, f6);
        StringPm insuranceTextPm = new StringPm(sending.getForms().getSpedi().getForwardingText());
        disposables.add(insuranceTextPm);
        StringField insuranceText = new StringField(insuranceTextPm);
        insuranceText.setFont(c2.getFont(Fonts.font8));
        panel.add(insuranceText);
        insuranceText.setBounds(c2.px(162.0), c2.py(96.5), c2.px(30.0), c2.py(5.0));
        insuranceText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
            }

            @Override
            public void focusGained(FocusEvent e2) {
                f6.setSelected(true);
                sending.getForms().getSpedi().getForwarding().setValue(5L);
            }
        });
    }

    private void addInsurance(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        double gap = 4.0;
        double x1 = 117.0;
        double y1 = 217.0;
        double x2 = 121.0;
        double y2 = 229.0;
        ButtonGroup insuranceGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, insuranceGroup, 117.0, 217.0, this.getText(sending, 760));
        JRadioButton mode2 = this.addRadioButton(panel, c2, insuranceGroup, 117.0, 221.0, this.getText(sending, 761));
        JRadioButton mode3 = this.addRadioButton(panel, c2, insuranceGroup, 117.0, 225.0, this.getText(sending, 762));
        this.connectRadio(disposables, insuranceGroup, sending.getForms().getSpedi().getInsurance(), mode1, mode2, mode3);
        ButtonGroup riskGroup = new ButtonGroup();
        JRadioButton risk1 = this.addRadioButton(panel, c2, riskGroup, 121.0, 229.0, this.getText(sending, 763));
        JRadioButton risk2 = this.addRadioButton(panel, c2, riskGroup, 121.0, 233.0, this.getText(sending, 764));
        JRadioButton risk3 = this.addRadioButton(panel, c2, riskGroup, 121.0, 237.0, this.getText(sending, 765));
        final JRadioButton risk4 = this.addRadioButton(panel, c2, riskGroup, 121.0, 241.0, "");
        this.connectRadio(disposables, null, sending.getForms().getSpedi().getInsuranceRisk(), risk1, risk2, risk3, risk4);
        StringPm insuranceAmountPm = new StringPm(sending.getForms().getSpedi().getInsuranceAmount());
        disposables.add(insuranceAmountPm);
        StringField insuranceAmount = new StringField(insuranceAmountPm);
        Font insuranceFont = c2.getFont(Fonts.font11);
        insuranceAmount.setFont(insuranceFont);
        panel.add(insuranceAmount);
        insuranceAmount.setBounds(c2.px(165.0), c2.py(225.5), c2.px(25.0), c2.py(5.0));
        StringPm insuranceTextPm = new StringPm(sending.getForms().getSpedi().getInsuranceText());
        disposables.add(insuranceTextPm);
        StringField insuranceText = new StringField(insuranceTextPm);
        insuranceText.setFont(insuranceFont);
        panel.add(insuranceText);
        insuranceText.setBounds(c2.px(126.0), c2.py(241.5), c2.px(64.0), c2.py(5.0));
        insuranceText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
            }

            @Override
            public void focusGained(FocusEvent e2) {
                risk4.doClick();
            }
        });
        this.updateInsuranceState(mode3, risk1, risk2, risk3, risk4, insuranceAmount, insuranceText);
        ActionListener insuranceListener = e2 -> this.updateInsuranceState(mode3, risk1, risk2, risk3, risk4, insuranceAmount, insuranceText);
        mode1.addActionListener(insuranceListener);
        mode2.addActionListener(insuranceListener);
        mode3.addActionListener(insuranceListener);
    }

    private void updateInsuranceState(JRadioButton radio, JComponent ... components) {
        boolean value = radio.isSelected();
        for (JComponent component : components) {
            component.setEnabled(value);
        }
    }

    private void addCleared(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, radioGroup, 32.0, 232.0, this.getText(sending, 766));
        JRadioButton mode2 = this.addRadioButton(panel, c2, radioGroup, 62.0, 232.0, this.getText(sending, 767));
        this.connectRadio(disposables, radioGroup, sending.getForms().getSpedi().getCleared(), mode1, mode2);
    }

    private void addTaxed(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, radioGroup, 32.0, 237.0, this.getText(sending, 768));
        JRadioButton mode2 = this.addRadioButton(panel, c2, radioGroup, 62.0, 237.0, this.getText(sending, 769));
        this.connectRadio(disposables, radioGroup, sending.getForms().getSpedi().getTaxed(), mode1, mode2);
    }

    private void addDeliveryMode(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton mode1 = this.addRadioButton(panel, c2, radioGroup, 116.0, 57.0, this.getText(sending, 770));
        JRadioButton mode2 = this.addRadioButton(panel, c2, radioGroup, 150.0, 57.0, this.getText(sending, 771));
        this.connectRadio(disposables, null, sending.getForms().getSpedi().getDeliveryMode(), mode1, mode2);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.renderTitleType(sending, renderContext);
        this.renderGoodsType(sending, renderContext);
        this.renderConsignor(sending, renderContext);
        this.renderCarrier(sending, renderContext);
        this.renderConsignee(sending, renderContext);
        this.renderDeliveryAddress(sending, renderContext);
        this.renderAllTexts(sending, renderContext);
        this.renderDocumentsForScreen(sending, renderContext);
        if (renderContext.isScreen()) {
            return;
        }
        this.renderCarnetATAnumber(sending, renderContext);
        this.renderDeliveryMode(sending, renderContext);
        this.renderForawrding(sending, renderContext);
        this.renderCleared(sending, renderContext);
        this.renderTaxed(sending, renderContext);
        this.renderInsurance(sending, renderContext);
        this.renderDocumentsForPrint(sending, renderContext);
        this.renderReference(sending, renderContext);
    }

    private void renderReference(Sending sending, IRenderContext renderContext) {
        BooleanNode declarantAsReference = sending.getForms().getSpedi().getDeclarantAsReference();
        String reference = declarantAsReference.getValue() != false ? sending.getGoodsDeclaration().getDeclarant().getDeclarantName().getValue() : sending.getForms().getSpedi().getFooterReference().getValue();
        renderContext.drawString(130.0, 249.0, Fonts.font10, Color.BLACK, reference);
    }

    private void renderDocumentsForScreen(Sending sending, IRenderContext rc) {
        if (!rc.isScreen()) {
            return;
        }
        rc.drawString(37.0, 252.0, Fonts.font8, Color.BLACK, this.getText(sending, 774));
        rc.drawString(37.0, 256.0, Fonts.font8, Color.BLACK, this.getText(sending, this.isEurMEDSelected(sending) ? 787 : 775));
        rc.drawString(37.0, 260.0, Fonts.font8, Color.BLACK, this.getText(sending, 776));
        rc.drawString(37.0, 264.0, Fonts.font8, Color.BLACK, this.getText(sending, 777));
        rc.drawString(37.0, 268.0, Fonts.font8, Color.BLACK, this.getText(sending, 778));
        rc.drawString(37.0, 272.0, Fonts.font8, Color.BLACK, this.getText(sending, 779));
        rc.drawString(37.0, 276.0, Fonts.font8, Color.BLACK, this.getText(sending, 780));
    }

    private boolean isEurMEDSelected(Sending sending) {
        return sending.getForms().getEur1().isEurMEDSelected();
    }

    private void renderAllTexts(Sending sending, IRenderContext rc) {
        rc.drawString(26.0, 17.0, Fonts.font8, Color.BLACK, this.getText(sending, 2300));
        rc.drawString(111.0, 17.0, Fonts.font8, Color.BLACK, this.getText(sending, 2301));
        rc.drawString(26.0, 55.0, Fonts.font8, Color.BLACK, this.getText(sending, sending.getGoodsDeclaration().getDelivery().isEnabled() ? 2319 : 2302));
        rc.drawString(26.0, 89.0, Fonts.font8, Color.BLACK, this.getText(sending, 2303));
        rc.drawString(111.0, 89.0, Fonts.font8, Color.BLACK, this.getText(sending, 2304));
        rc.drawString(111.0, 105.0, Fonts.font8, Color.BLACK, this.getText(sending, 2305));
        rc.drawString(26.0, 124.0, Fonts.font8, Color.BLACK, this.getText(sending, 2306));
        rc.drawString(111.0, 124.0, Fonts.font8, Color.BLACK, this.getText(sending, 2307));
        rc.drawString(26.0, 150.0, Fonts.font8, Color.BLACK, this.getText(sending, 2308));
        rc.drawString(111.0, 150.0, Fonts.font8, Color.BLACK, this.getText(sending, 2309));
        rc.drawString(26.0, 165.0, Fonts.font8, Color.BLACK, this.getText(sending, 2310));
        rc.drawString(26.0, 212.0, Fonts.font8, Color.BLACK, this.getText(sending, 2311));
        rc.drawString(32.0, 223.3, Fonts.font8, Color.BLACK, this.getText(sending, 2318));
        rc.drawString(111.0, 212.0, Fonts.font8, Color.BLACK, this.getText(sending, 2312));
        rc.drawString(26.0, 247.0, Fonts.font8, Color.BLACK, this.getText(sending, 2313));
        rc.drawString(111.0, 250.0, Fonts.font8, Color.BLACK, this.getText(sending, 2314));
        rc.drawString(111.0, 255.0, Fonts.font8, Color.BLACK, this.getText(sending, 2315));
        rc.drawString(111.0, 260.0, Fonts.font8, Color.BLACK, this.getText(sending, 2316));
    }

    private void renderCarnetATAnumber(Sending sending, IRenderContext rc) {
        if (sending.getForms().getSpedi().getGoodsType().getIntValue() == 1) {
            rc.drawString(39.0, 138.0, Fonts.font11, Color.BLACK, sending.getForms().getSpedi().getCarnetATAnumber().getValue());
        }
    }

    private void renderGoodsType(Sending sending, IRenderContext rc) {
        rc.drawString(32.0, 131.0, Fonts.font11bold, Color.BLACK, this.getGoodsTypeLine(sending));
        if (sending.getForms().getSpedi().getGoodsType().getIntValue() == 0) {
            rc.drawString(39.0, 138.0, Fonts.font11, Color.BLACK, sending.getGoodsDeclaration().getCustomsDeclarationNumber().getValue());
        }
    }

    private String getGoodsTypeLine(Sending sending) {
        switch (sending.getForms().getSpedi().getGoodsType().getIntValue()) {
            case 0: {
                return this.getText(sending, 772);
            }
            case 1: {
                return this.getText(sending, 773);
            }
        }
        throw Check.fail("unexpected type " + sending.getForms().getBill().getType().getIntValue());
    }

    private void renderTitleType(Sending sending, IRenderContext rc) {
        rc.drawString(25.0, 7.0, Fonts.font20bold, Color.BLACK, this.getTitleTypeLine(sending));
    }

    private String getTitleTypeLine(Sending sending) {
        switch (sending.getForms().getSpedi().getTitleType().getIntValue()) {
            case 0: {
                return this.getText(sending, 750);
            }
            case 1: {
                return this.getText(sending, 751);
            }
            case 2: {
                return this.getText(sending, 752);
            }
        }
        throw Check.fail("unexpected type " + sending.getForms().getBill().getType().getIntValue());
    }

    private void renderDocumentsForPrint(Sending sending, IRenderContext renderContext) {
        DocumentPlacer placer = new DocumentPlacer(renderContext);
        Spedi spedi = sending.getForms().getSpedi();
        placer.add(spedi.getDocAusfuhrliste().isInitialized(), spedi.getDocAusfuhrliste(), this.getText(sending, 774));
        placer.add(spedi.getDocEUR1().isInitialized() || sending.getForms().getEur1().getEur1Number().isInitialized() && sending.getForms().getEur1().isEnabled(), spedi.getDocEUR1(), this.getText(sending, this.isEurMEDSelected(sending) ? 787 : 775) + " " + sending.getForms().getEur1().getEur1Number().getValue());
        placer.add(spedi.getDocUZ().isInitialized(), spedi.getDocUZ(), this.getText(sending, 776));
        placer.add(spedi.getDocHandelsrechnung().isInitialized(), spedi.getDocHandelsrechnung(), this.getText(sending, 777));
        placer.add(spedi.getDocPacklisten().isInitialized(), spedi.getDocPacklisten(), this.getText(sending, 778));
        placer.add(spedi.getDocAkkreditiv().isInitialized(), spedi.getDocAkkreditiv(), this.getText(sending, 779));
        placer.add(spedi.getDocAusfuhrbewilligung().isInitialized(), spedi.getDocAusfuhrbewilligung(), this.getText(sending, 780));
        placer.add(spedi.getDocCustom().isInitialized(), spedi.getDocCustom(), spedi.getDocCustomText().getValue());
    }

    private void renderForawrding(Sending sending, IRenderContext renderContext) {
        String text = this.getForwardingText(sending);
        renderContext.drawString(117.0, 94.0, Fonts.font11, Color.BLACK, text);
    }

    private String getForwardingText(Sending sending) {
        IntegralNode forwarding = sending.getForms().getSpedi().getForwarding();
        if (!forwarding.isInitialized()) {
            return "";
        }
        switch (forwarding.getIntValue()) {
            case 0: {
                return this.getText(sending, 755);
            }
            case 1: {
                return this.getText(sending, 756);
            }
            case 2: {
                return this.getText(sending, 757);
            }
            case 3: {
                return this.getText(sending, 758);
            }
            case 4: {
                return this.getText(sending, 759);
            }
            case 5: {
                return sending.getForms().getSpedi().getForwardingText().getValue();
            }
        }
        throw Check.fail("unexpected forwarding:", forwarding);
    }

    private void renderInsurance(Sending sending, IRenderContext renderContext) {
        double gap = 5.0;
        double x1 = 117.0;
        double y1 = 217.0;
        Spedi spedi = sending.getForms().getSpedi();
        if (!spedi.getInsurance().isInitialized()) {
            return;
        }
        int value = spedi.getInsurance().getIntValue();
        renderContext.renderCheckBox(this.getText(sending, 760), Fonts.font11, value == 0, 117.0, 217.0);
        renderContext.renderCheckBox(this.getText(sending, 761), Fonts.font11, value == 1, 117.0, 222.0);
        renderContext.renderCheckBox(this.getText(sending, 781), Fonts.font11, value == 2, 117.0, 227.0);
        if (value != 2) {
            return;
        }
        renderContext.drawString(121.0, 232.0, Fonts.font11, Color.BLACK, this.getText(sending, 782) + " " + spedi.getInsuranceAmount().toString());
        String text = this.getInsuranceText(sending, spedi);
        renderContext.drawString(121.0, 237.0, Fonts.font11, Color.BLACK, text);
    }

    private String getInsuranceText(Sending sending, Spedi spedi) {
        switch (spedi.getInsuranceRisk().getIntValue()) {
            case 0: {
                return this.getText(sending, 763);
            }
            case 1: {
                return this.getText(sending, 764);
            }
            case 2: {
                return this.getText(sending, 765);
            }
            case 3: {
                return spedi.getInsuranceText().getValue();
            }
        }
        throw Check.fail("unknown risk", spedi.getInsuranceRisk());
    }

    private void renderConsignee(Sending sending, IRenderContext renderContext) {
        Address consignee = sending.getGoodsDeclaration().getConsignee();
        this.renderAddressAndContact(consignee, renderContext, 32.0, 59.0);
    }

    private void renderDeliveryAddress(Sending sending, IRenderContext renderContext) {
        Address deliveryAddress = sending.getGoodsDeclaration().getDelivery();
        if (!deliveryAddress.isEnabled()) {
            renderContext.drawString(32.0, 94.0, Fonts.font9, Color.BLACK, this.getText(sending, 783));
            return;
        }
        this.renderAddressAndContact(deliveryAddress, renderContext, 32.0, 94.0);
    }

    private void renderCleared(Sending sending, IRenderContext renderContext) {
        IntegralNode cleared = sending.getForms().getSpedi().getCleared();
        if (!cleared.isInitialized()) {
            return;
        }
        boolean value = cleared.getIntValue() == 0;
        renderContext.renderCheckBox(this.getText(sending, 766), Fonts.font11, value, 32.0, 232.0);
        renderContext.renderCheckBox(this.getText(sending, 767), Fonts.font11, !value, 62.0, 232.0);
    }

    private void renderTaxed(Sending sending, IRenderContext renderContext) {
        IntegralNode taxed = sending.getForms().getSpedi().getTaxed();
        if (!taxed.isInitialized()) {
            return;
        }
        boolean value = taxed.getIntValue() == 0;
        renderContext.renderCheckBox(this.getText(sending, 768), Fonts.font11, value, 32.0, 237.0);
        renderContext.renderCheckBox(this.getText(sending, 769), Fonts.font11, !value, 62.0, 237.0);
    }

    private void renderDeliveryMode(Sending sending, IRenderContext renderContext) {
        boolean value = sending.getForms().getSpedi().getDeliveryMode().getIntValue() == 0;
        renderContext.renderCheckBox(this.getText(sending, 770), Fonts.font8, value, 117.0, 58.0);
        renderContext.renderCheckBox(this.getText(sending, 771), Fonts.font8, !value, 150.0, 58.0);
    }

    private void renderCarrier(Sending sending, IRenderContext renderContext) {
        Carrier carrier = sending.getGoodsDeclaration().getCarrier();
        AddressRenderer renderer = carrier.getAddress();
        this.renderAddress(renderer, renderContext, 117.0, 21.0);
        this.drawSmallString(renderContext, 117.0, 47.0, 75.0, carrier.getContact().getValue());
        this.drawSmallString(renderContext, 117.0, 50.0, 75.0, carrier.getPhoneAndEmail());
    }

    private void renderConsignor(Sending sending, IRenderContext renderContext) {
        AddressRenderer renderer = sending.getGoodsDeclaration().getConsignor().getAddress();
        this.renderAddress(renderer, renderContext, 32.0, 21.0);
        this.drawSmallString(renderContext, 32.0, 47.0, 75.0, sending.getGoodsDeclaration().getDeclarant().getDeclarantName().getValue());
        Object telMail = sending.getPhone();
        if (!((String)telMail).isEmpty()) {
            telMail = (String)telMail + "  ";
        }
        telMail = (String)telMail + sending.getConsignorEMail();
        this.drawSmallString(renderContext, 32.0, 50.0, 75.0, (String)telMail);
    }

    private void renderAddressAndContact(Address address, IRenderContext renderContext, double x, double y) {
        this.renderAddress(address.getAddress(), renderContext, x, y);
        this.drawSmallString(renderContext, x, y + 22.0, 75.0, address.getContact().getValue());
        this.drawSmallString(renderContext, x, y + 25.0, 75.0, address.getPhoneAndEmail());
    }

    private void renderAddress(AddressRenderer address, IRenderContext renderContext, double x, double y) {
        if (address.getNumberOfLines() > 5) {
            address.render(renderContext, x, y, Fonts.font8);
        } else {
            address.render(renderContext, x, y, Fonts.font9);
        }
    }

    private void drawSmallString(IRenderContext renderContext, double x, double y, double maxWidth, String str) {
        renderContext.drawStringCut(x, y, maxWidth, Fonts.font8, Color.BLACK, str);
    }

    private String getText(Sending sending, int id) {
        if (sending.getForms().getSpedi().getSpediInEnglish().getValue().booleanValue()) {
            return Services.get(ITextService.class).getText(ITextService.Language.en, id);
        }
        return Services.getText(id);
    }

    private static class DocumentPlacer {
        private static final double x1 = 32.0;
        private static final double x2 = 36.0;
        private static final double advance = 4.0;
        private final IRenderContext context;
        private double y = 252.0;

        public DocumentPlacer(IRenderContext context) {
            this.context = context;
        }

        public void add(boolean condition, IntegralNode node, String text) {
            if (!condition) {
                return;
            }
            this.context.drawString(32.0, this.y, font, Color.BLACK, node.getStringValue());
            this.context.drawString(36.0, this.y, font, Color.BLACK, text);
            this.y += 4.0;
        }
    }
}

