/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.logging;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.webservices.bugreport.SendBugReportFacade;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.Check;
import java.io.FileNotFoundException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingService
implements ILoggingService {
    private Logger logger;
    private FileHandler fh;
    private boolean logUncauthIsActive = false;

    public LoggingService() {
        try {
            this.logger = Logger.getLogger("expovit");
            this.fh = new FileHandler(this.getLogFilePath(), 1000000, 2, true);
            this.fh.setFormatter(new SimpleFormatter());
            this.logger.addHandler(this.fh);
            this.logger.setLevel(Level.ALL);
        }
        catch (Exception e2) {
            this.showErrorDialog(e2, "Failed to open log file: " + this.getLogFilePath(), new String[0]);
            SendBugReportFacade.send(false, e2);
        }
    }

    @Override
    public void logSilentWithBugMail(Throwable t, String ... message) {
        this.logSilent(t, message);
        SendBugReportFacade.send(false, t, message);
    }

    private String getLogFilePath() {
        return Services.get(IConfigService.class).getLogFilePath().getPath();
    }

    @Override
    public synchronized void logSilent(Throwable t, String ... messages) {
        String message = Check.createMessage(messages);
        this.logger.log(Level.SEVERE, message, t);
    }

    @Override
    public synchronized void logSilent(String ... messages) {
        String message = Check.createMessage(messages);
        this.logger.log(Level.WARNING, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void logUncaughtException(Throwable t, String threadName) {
        if (this.logUncauthIsActive) {
            return;
        }
        this.logUncauthIsActive = true;
        try {
            this.logSilent(t, threadName);
            this.showErrorDialog(t, Services.getText(613), Services.getText(614));
            if (Services.get(IAppService.class).askSavePendingChanges()) {
                Services.get(IGuiService.class).shutdown();
            }
            SendBugReportFacade.send(true, t);
        }
        catch (Exception e2) {
            SendBugReportFacade.send(true, e2);
            Services.get(IGuiService.class).shutdown();
        }
        finally {
            this.logUncauthIsActive = false;
        }
    }

    @Override
    public synchronized void logAndReport(String title, String ... message) {
        this.showErrorDialog(title, message);
    }

    @Override
    public void logAndReport(String message) {
        this.logAndReport(Services.getText(613), message);
    }

    @Override
    public synchronized void logAndReport(Throwable t, String ... message) {
        this.logSilent(t, message);
        this.showErrorDialog(t, Services.getText(613), message);
        SendBugReportFacade.send(false, t, message);
    }

    private void showErrorDialog(String title, String ... message) {
        String msg = Check.createMessage(message);
        this.showErrorDialog(title, msg);
    }

    private void showErrorDialog(Throwable t, String title, String ... message) {
        String msg = Check.createMessage(message) + "\n\n" + Services.getText(615) + "\n" + LoggingService.getExceptionMessage(t);
        this.showErrorDialog(title, msg);
    }

    public static String getExceptionMessage(Throwable t) {
        StringBuilder result = new StringBuilder();
        for (Throwable current = t; current != null; current = current.getCause()) {
            if (current.getMessage() == null) continue;
            if (current instanceof FileNotFoundException) {
                result.append("File not found: ");
            }
            result.append(current.getMessage());
            result.append("\n");
        }
        String resultStr = result.toString();
        if (resultStr.isEmpty()) {
            return t.getClass().getSimpleName();
        }
        return resultStr;
    }

    private void showErrorDialog(String title, String message) {
        DialogUtil.showErrorDialog(title, message);
    }
}

