/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv;

import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.pm.model.ISelectionFieldData;
import ch.transsoft.edec.util.Check;

public class DomainValue
implements ISelectionFieldData {
    private final String key;
    private final String textDe;
    private final String textFr;
    private final String textIt;
    private final String textEn;
    private final boolean showDescOnly;
    private static final DomainValue uninitialized = new DomainValue("", "", "", "", "");

    public static DomainValue getUninitialized() {
        return uninitialized;
    }

    public static DomainValue createUnknown(String valueName) {
        return new DomainValue(valueName);
    }

    public DomainValue(String key) {
        this(key, "", "", "", "");
    }

    public DomainValue(String key, String de, String fr, String it, String en) {
        this(key, de, fr, it, en, false);
    }

    public DomainValue(String key, String de, String fr, String it, String en, boolean showDescOnly) {
        this.showDescOnly = showDescOnly;
        Check.assertNotNull(key);
        this.key = key;
        this.textDe = de;
        this.textFr = fr;
        this.textIt = it;
        this.textEn = en;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String getDe() {
        return this.textDe;
    }

    public String getFr() {
        return this.textFr;
    }

    public String getIt() {
        return this.textIt;
    }

    public String getEn() {
        return this.textEn;
    }

    public int getKeyAsInt() {
        return Integer.parseInt(this.key);
    }

    public String toString() {
        if (this.showDescOnly) {
            return this.getDesc();
        }
        return this.getKey() + " " + this.getDesc();
    }

    public boolean isInitialized() {
        return this != uninitialized;
    }

    @Override
    public String getDesc() {
        return this.getDesc(Services.get(ITextService.class).getCurrentLanguage());
    }

    @Override
    public String getDesc(ITextService.Language language) {
        switch (language) {
            case de: {
                return this.textDe;
            }
            case fr: {
                return this.textFr;
            }
            case it: {
                return this.textIt;
            }
            case en: {
                return this.textEn;
            }
        }
        throw Check.fail(new Object[]{"unknown langauge", Services.get(ITextService.class).getCurrentLanguage()});
    }

    public String getDescEn() {
        return this.textEn;
    }

    public boolean containsText(String text) {
        return this.textDe.contains(text) || this.textFr.contains(text) || this.textIt.contains(text) || this.textEn.contains(text);
    }

    public StringNode getDescAsStringNode() {
        return new StringNode(this.getDesc());
    }
}

