/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv.internal;

import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.masterdataezv.internal.DomainDataBody;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CountryLoader
extends DefaultHandler {
    public static final DomainValue CE = new DomainValue("CE", "Europ\u00e4ische Gemeinschaft", "Communaut\u00e9s europ\u00e9ennes", "Unione Europea", "European Community");
    public static final DomainValue TPC = new DomainValue("**", "Drittland", "Pays Tiers", "Paese Terzo", "Third Party Country");
    public static final DomainValue WO = new DomainValue("WO", "Origin Criterion China", "Origin Criterion China", "Origin Criterion China", "Origin Criterion China");
    public static final DomainValue WP = new DomainValue("WP", "Origin Criterion China", "Origin Criterion China", "Origin Criterion China", "Origin Criterion China");
    public static final DomainValue PSR = new DomainValue("PSR", "Origin Criterion China", "Origin Criterion China", "Origin Criterion China", "Origin Criterion China");
    private static final String COUNTRIES = "countries";
    private static final String COUNTRY = "country";
    private static final String COUNTRY_GROUP_ASSIGNMENT = "countryGroupAssignment";
    private static final String VALID_FROM = "validFrom";
    private static final String VALID_TO = "validTo";
    private static final String ISO_CODE = "isoCode";
    private static final String NAME_DE = "nameDe";
    private static final String NAME_FR = "nameFr";
    private static final String NAME_IT = "nameIt";
    private static final String NAME_EN = "nameEn";
    private static final String GRP_NR = "grpNr";
    private DomainDataBody isoCodes;
    private DomainDataBody isoCodesWithCE;
    private DomainValue currentCountry;
    private final Map<Domain, DomainDataBody> domainData;
    private final Set<DomainValue> securityZone;
    private final Set<DomainValue> euZone;

    public CountryLoader(Map<Domain, DomainDataBody> domainData, Set<DomainValue> securityZone, Set<DomainValue> euZone) {
        this.domainData = domainData;
        this.securityZone = securityZone;
        this.euZone = euZone;
    }

    public void load() {
        try {
            this.readFile("edecCountryCodes_1_0.xml");
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    private void readFile(String fileName) throws Exception {
        InputStream inputStream = CountryLoader.class.getResourceAsStream("data/" + fileName);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(inputStream, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(COUNTRIES)) {
            this.handleStartCountries();
        } else if (name.equals(COUNTRY)) {
            this.handleCountry(attributes);
        } else if (name.equals(COUNTRY_GROUP_ASSIGNMENT)) {
            this.handleCountryGroupAssignment(attributes);
        }
    }

    private void handleCountryGroupAssignment(Attributes attributes) {
        if (!DateUtil.isValid(attributes.getValue(VALID_FROM), attributes.getValue(VALID_TO))) {
            return;
        }
        if (attributes.getValue(GRP_NR).equals("300001")) {
            this.securityZone.add(this.currentCountry);
        }
        if (attributes.getValue(GRP_NR).equals("100001")) {
            this.euZone.add(this.currentCountry);
        }
    }

    private void handleCountry(Attributes attributes) {
        if (!DateUtil.isValid(attributes.getValue(VALID_FROM), attributes.getValue(VALID_TO))) {
            return;
        }
        this.currentCountry = new DomainValue(attributes.getValue(ISO_CODE), this.strip(attributes.getValue(NAME_DE)), this.strip(attributes.getValue(NAME_FR)), this.strip(attributes.getValue(NAME_IT)), this.strip(attributes.getValue(NAME_EN)), false);
        this.isoCodes.put(this.currentCountry);
        this.isoCodesWithCE.put(this.currentCountry);
    }

    private String strip(String value) {
        int index = value.indexOf(40);
        if (index == -1) {
            return value;
        }
        return (String)value.subSequence(0, index - 1);
    }

    private void handleStartCountries() {
        this.isoCodes = new DomainDataBody(Domain.isoCode);
        this.isoCodesWithCE = new DomainDataBody(Domain.isoCodeWithCE);
        this.isoCodesWithCE.put(CE);
        this.isoCodesWithCE.put(TPC);
        this.isoCodesWithCE.put(WO);
        this.isoCodesWithCE.put(WP);
        this.isoCodesWithCE.put(PSR);
        this.domainData.put(Domain.isoCode, this.isoCodes);
        this.domainData.put(Domain.isoCodeWithCE, this.isoCodesWithCE);
    }
}

