/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv.internal;

import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.masterdataezv.internal.DomainDataBody;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CustomsOfficeLoader
extends DefaultHandler {
    private static final String OFFICES = "customsOffices";
    private static final String OFFICE = "customsOffice";
    private static final String VALID_FROM = "validFrom";
    private static final String VALID_TO = "validTo";
    private static final String NUMBER = "number";
    private static final String PREFIX = "prefix";
    private static final String NAME = "name";
    private static final String ADDRESS = "address";
    private static final String CITY = "city";
    private DomainDataBody currentOffices;
    private DomainValue currentCountry;
    private final Map<Domain, DomainDataBody> domainData;

    public CustomsOfficeLoader(Map<Domain, DomainDataBody> domainData) {
        this.domainData = domainData;
    }

    public void load() {
        try {
            this.readFile("edecCustomsOffices.xml");
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    private void readFile(String fileName) throws Exception {
        InputStream inputStream = CustomsOfficeLoader.class.getResourceAsStream("data/" + fileName);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(inputStream, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(OFFICES)) {
            this.handleStartOffices();
        } else if (name.equals(OFFICE)) {
            this.handleOffice(attributes);
        }
    }

    private void handleOffice(Attributes attributes) {
        if (!DateUtil.isValid(attributes.getValue(VALID_FROM), attributes.getValue(VALID_TO))) {
            return;
        }
        String officeName = attributes.getValue(PREFIX) + ", " + attributes.getValue(NAME) + ", " + attributes.getValue(ADDRESS) + ", " + attributes.getValue(CITY);
        this.currentCountry = new DomainValue(attributes.getValue(NUMBER), officeName, officeName, officeName, officeName, false);
        this.currentOffices.put(this.currentCountry);
    }

    private void handleStartOffices() {
        this.currentOffices = new DomainDataBody(Domain.notificationCode);
        this.domainData.put(Domain.notificationCode, this.currentOffices);
    }
}

