/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv.internal;

import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.CountryLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum Domain {
    invoiceCurrencyType,
    moduleSelection,
    notificationCode(true),
    grossupType,
    chamberOfCommerce,
    encoding,
    delimiter,
    importKey,
    gender,
    correspondenceLanguage,
    documentLanguage,
    isoCode(true),
    isoCodeWithCE(true, CountryLoader.CE, "CE", "**", "WO", "WP", "PSR"),
    billingType,
    clearanceLocation("5"),
    commercialGood,
    confirmationCode,
    correctionCode,
    correctionReason,
    customsClearanceType("3", "9", "10", "11"),
    customsOfficeNumber,
    declarationTime,
    declarationType,
    direction,
    documentType(true, "954"),
    status,
    goodsItemDetailName,
    incoterms,
    initiator,
    injunctionType,
    language,
    nonCustomsLawObligation,
    nonCustomsLawType,
    packagingType(true, GoodsData.BEIPACK, "CT", "CH", "NE", "PK", "PX", "--"),
    permitAuthority,
    permitItemDetailName,
    permitObligation,
    permitType,
    positionType,
    postalShipmentType,
    previousDocumentType,
    procedureType,
    processType,
    reason,
    refinementType,
    refundType,
    selectionResult,
    serviceType,
    storageType,
    tobaccoType,
    transportationType,
    transportMode,
    VATCode,
    vehicleModelCode,
    warehouseCoded,
    yesNoCode;

    private final boolean orderByDesc;
    private final Set<String> excludeList = new HashSet<String>();
    private final List<DomainValue> additional = new ArrayList<DomainValue>();
    private final List<String> favorites = new ArrayList<String>();

    private Domain() {
        this(false);
    }

    private Domain(boolean orderByDesc, DomainValue additional, String ... favorites) {
        this(orderByDesc);
        this.additional.add(additional);
        for (String current : favorites) {
            this.favorites.add(current);
        }
    }

    private Domain(String ... excludeList) {
        this(false, excludeList);
    }

    private Domain(boolean orderByDesc) {
        this(orderByDesc, new String[0]);
    }

    private Domain(boolean orderByDesc, String ... excludeList) {
        this.orderByDesc = orderByDesc;
        for (String value : excludeList) {
            this.excludeList.add(value);
        }
    }

    boolean isOrderByDesc() {
        return this.orderByDesc;
    }

    public boolean exclude(String value) {
        return this.excludeList.contains(value);
    }

    public List<DomainValue> getAdditional() {
        return this.additional;
    }

    public List<String> getFavorites() {
        return this.favorites;
    }

    public boolean isAutocompleteKey() {
        return !this.orderByDesc;
    }

    public boolean isFavorite(String key) {
        return this.favorites.contains(key);
    }
}

