/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.masterdataezv.internal;

import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.masterdataezv.internal.DomainDataBody;
import ch.transsoft.edec.service.masterdataezv.internal.MasterDataEZVService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DomainLoader
extends DefaultHandler {
    private static final String DOMAIN = "domain";
    private static final String ENTRY = "entry";
    private static final String VALID_FROM = "validFrom";
    private static final String VALID_TO = "validTo";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String MEANING_DE = "meaningDe";
    private static final String MEANING_FR = "meaningFr";
    private static final String MEANING_IT = "meaningIt";
    private static final String MEANING_EN = "meaningEn";
    private static final String VALID_FOR_EXPORT = "validForExport";
    private DomainDataBody current;
    private final Map<Domain, DomainDataBody> domainData;

    public DomainLoader(Map<Domain, DomainDataBody> domainData) {
        this.domainData = domainData;
    }

    public void load() {
        try {
            this.readFile("edecDomains_1_0.xml");
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    private void readFile(String fileName) throws Exception {
        InputStream inputStream = MasterDataEZVService.class.getResourceAsStream("data/" + fileName);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(inputStream, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(DOMAIN)) {
            this.handleStartDomain(attributes);
        } else if (name.equals(ENTRY)) {
            this.handleEntry(attributes);
        }
    }

    private void handleEntry(Attributes attributes) {
        if (this.current == null) {
            return;
        }
        if (!DateUtil.isValid(attributes.getValue(VALID_FROM), attributes.getValue(VALID_TO))) {
            return;
        }
        if (!this.isValidForExport(attributes)) {
            return;
        }
        String value = attributes.getValue(VALUE);
        if (this.current.exclude(value)) {
            return;
        }
        DomainValue domainValue = new DomainValue(value, attributes.getValue(MEANING_DE), attributes.getValue(MEANING_FR), attributes.getValue(MEANING_IT), attributes.getValue(MEANING_EN), false);
        this.current.put(domainValue);
    }

    private boolean isValidForExport(Attributes attributes) {
        String attr = attributes.getValue(VALID_FOR_EXPORT);
        if (attr == null) {
            return true;
        }
        return attr.toLowerCase().equals("true");
    }

    private void handleStartDomain(Attributes attributes) {
        String name = attributes.getValue(NAME);
        Domain domain = null;
        try {
            domain = Domain.valueOf(name);
        }
        catch (IllegalArgumentException e2) {
            this.current = null;
            return;
        }
        this.current = new DomainDataBody(domain);
        this.domainData.put(domain, this.current);
        for (DomainValue value : domain.getAdditional()) {
            this.current.put(value);
        }
    }
}

