/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.outlook;

import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.outlook.IOutlookService;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SystemUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.mail.OutlookMail;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class OutlookService
implements IOutlookService {
    private boolean dllReady = false;

    @Override
    public boolean send(CarrierMail mailInfo, ListNode<AttachmentEntry> attachments, Object attachmentContext) {
        if (!SystemUtil.isOsWindows()) {
            Services.get(ILoggingService.class).logAndReport(Services.getText(896));
            return false;
        }
        try {
            this.provideMoyosoftDll();
            Outlook outlookApplication = new Outlook();
            OutlookFolder outbox = outlookApplication.getDefaultFolder(FolderType.OUTBOX);
            OutlookMail mail = new OutlookMail(outbox);
            mail.setSubject(mailInfo.getSubject());
            mail.setBody(mailInfo.getContent());
            mail.setTo(this.createToAddress(mailInfo));
            File tempDir = Services.get(IConfigService.class).getTempDir();
            for (AttachmentEntry attachment : attachments) {
                IAttachmentBody body = attachment.getAttachmentHandle().getBody();
                File tempFile = new File(tempDir, body.getFileName());
                tempFile.deleteOnExit();
                FileUtil.copy((InputStream)new ByteArrayInputStream(body.getData(attachmentContext)), tempFile);
                mail.getAttachments().add(tempFile);
            }
            mail.send();
            outlookApplication.dispose();
            return true;
        }
        catch (ComponentObjectModelException ex) {
            Services.get(ILoggingService.class).logAndReport(Services.getText(600), ex.getMessage());
            Services.get(ILoggingService.class).logSilentWithBugMail(ex, ex.getMessage());
        }
        catch (Exception ex) {
            Services.get(ILoggingService.class).logAndReport(ex, Services.getText(600));
        }
        return false;
    }

    private String createToAddress(CarrierMail mailInfo) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < mailInfo.getToAddresses().size(); ++i2) {
            if (i2 != 0) {
                result.append(";");
            }
            result.append(mailInfo.getToAddresses().get(i2));
        }
        return result.toString();
    }

    private void provideMoyosoftDll() throws IOException {
        if (this.dllReady) {
            return;
        }
        if (System.getProperty("java.library.path").contains("moyocore_dll")) {
            this.dllReady = true;
            Services.get(ILoggingService.class).logSilent("moyocore_dll found in java.library.path");
            return;
        }
        File folder = new File(Services.get(IConfigService.class).getTempDir(), "ExpoVit_DLL");
        folder.mkdirs();
        String dllFile = "moyocore_x64.dll";
        File path = new File(folder, "moyocore_x64.dll");
        try (InputStream stream = this.getClass().getResourceAsStream("moyocore_x64.dll");){
            if (stream == null) {
                throw new FileNotFoundException("moyocore_x64.dll not found in classpath.");
            }
            if (!path.exists() || path.length() != (long)stream.readAllBytes().length) {
                FileUtil.copy(this.getClass().getResourceAsStream("moyocore_x64.dll"), path);
                Services.get(ILoggingService.class).logSilent("Copied moyocore-dll to " + String.valueOf(path));
            }
        }
        Services.get(ILoggingService.class).logSilent("Using moyocore-dll from " + String.valueOf(path));
        Outlook.setLibraryPath(path.getPath());
        this.dllReady = true;
    }
}

