/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.printer;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.TextUtil;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.standard.MediaTray;

public class Printer {
    public static final String DEFAULT_PRINTER = "Default Printer";
    private PrintService printer;
    private List<MediaTray> mediaTrays;
    private boolean supportsDuplex;
    private final boolean isDefaultPrinter;

    public Printer(PrintService printer, boolean supportsDuplex, List<MediaTray> mediaTrays, boolean defaultPrinter) {
        this.printer = printer;
        this.supportsDuplex = supportsDuplex;
        this.mediaTrays = mediaTrays;
        this.isDefaultPrinter = defaultPrinter;
    }

    public String getId() {
        if (this.isDefaultPrinter) {
            return DEFAULT_PRINTER;
        }
        return this.getChangedDeviceName();
    }

    private String getChangedDeviceName() {
        return Services.get(IConfigService.class).getPrintNameCorrection().getCorrectedName(this.getDeviceName());
    }

    public String getDeviceName() {
        return this.printer.getName();
    }

    public MediaTray getMediaTray(int index) {
        for (MediaTray current : this.mediaTrays) {
            if (current.getValue() != index) continue;
            return current;
        }
        return null;
    }

    public boolean isSupportsDuplex() {
        return this.supportsDuplex;
    }

    public List<MediaTray> getMediaTrays() {
        return this.mediaTrays;
    }

    public String toString() {
        String shortName;
        String string = shortName = this.isDefaultPrinter ? TextUtil.cut(this.getChangedDeviceName(), 30) : TextUtil.cut(this.getId(), 30);
        if (this.isDefaultPrinter) {
            return "Default Printer (" + shortName + ")";
        }
        return shortName;
    }

    public boolean isDefaultPrinter() {
        return this.isDefaultPrinter;
    }

    public PrintService getPrintService() {
        return this.printer;
    }
}

