/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.printer;

import ch.transsoft.edec.service.printer.IPrinterHandler;
import ch.transsoft.edec.service.printer.IPrinterService;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.service.printer.PrinterList;
import ch.transsoft.edec.service.printer.PrinterService;
import java.util.List;
import javax.swing.SwingWorker;

public final class PrinterFetcher
extends SwingWorker<PrinterList, Printer> {
    private final IPrinterHandler handler;
    private PrinterList result;
    private final IPrinterService printerService;

    public PrinterFetcher(IPrinterService printerService, IPrinterHandler handler) {
        this.printerService = printerService;
        this.handler = handler;
    }

    public PrinterFetcher(PrinterService printerService) {
        this(printerService, IPrinterHandler.NoOp);
    }

    @Override
    protected PrinterList doInBackground() throws Exception {
        this.result = this.printerService.refresh(xva$0 -> this.publish(xva$0));
        return this.result;
    }

    @Override
    protected void done() {
        this.printerService.setPrinterList(this.result);
        this.handler.finish(this.result);
    }

    @Override
    protected void process(List<Printer> chunks) {
        for (Printer current : chunks) {
            this.handler.next(current);
        }
    }
}

