/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.printer;

import ch.transsoft.edec.service.printer.DeviceRegistry;
import ch.transsoft.edec.service.printer.IPrinterHandler;
import ch.transsoft.edec.service.printer.IPrinterRefreshProgress;
import ch.transsoft.edec.service.printer.IPrinterService;
import ch.transsoft.edec.service.printer.Printer;
import ch.transsoft.edec.service.printer.PrinterList;
import ch.transsoft.edec.util.Check;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class PrinterService
implements IPrinterService {
    private PrinterList printers = new PrinterList();
    private final DeviceRegistry registry = new DeviceRegistry();

    @Override
    public PrinterList refresh(IPrinterRefreshProgress printerHandler) {
        PrinterList result = new PrinterList();
        PrintService defaultPrinter = PrintServiceLookup.lookupDefaultPrintService();
        Printer dPrinter = this.createPrinter(defaultPrinter, true);
        result.add(dPrinter);
        printerHandler.next(dPrinter);
        for (PrintService printService : PrintServiceLookup.lookupPrintServices(null, null)) {
            if (result.size() == 40) {
                return result;
            }
            Printer printer = this.createPrinter(printService, false);
            result.add(printer);
            printerHandler.next(printer);
        }
        return result;
    }

    private Printer createPrinter(PrintService printService, boolean defaultPrinter) {
        return new Printer(printService, this.registry.isDuplex(printService), this.registry.getMediaTrays(printService), defaultPrinter);
    }

    @Override
    public void setPrinterList(PrinterList printers) {
        this.printers = printers;
    }

    @Override
    public Printer getPrinter(String printerId) {
        if (printerId.equals("Default Printer")) {
            return this.createPrinter(PrintServiceLookup.lookupDefaultPrintService(), true);
        }
        HashPrintServiceAttributeSet printServiceAttrs = new HashPrintServiceAttributeSet();
        printServiceAttrs.add(new PrinterName(printerId, null));
        PrintService[] found = PrintServiceLookup.lookupPrintServices(null, printServiceAttrs);
        if (found.length == 0) {
            return this.getPrinterByManualSearch(printerId);
        }
        return this.createPrinter(found[0], false);
    }

    @Override
    public Printer getPrinterByManualSearch(String printerId) {
        if (this.printers.isEmpty()) {
            this.printers = this.refresh(IPrinterHandler.NoOp);
        }
        Printer result = this.printers.find(printerId);
        Check.assertNotNull(result);
        return result;
    }
}

