/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.proxy;

import ch.transsoft.edec.model.config.conf.options.ProxyInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.proxy.CustomProxySelector;
import ch.transsoft.edec.service.proxy.IConnectionService;
import ch.transsoft.edec.service.proxy.RootImportInflatableTrustManager;
import ch.transsoft.edec.ui.dialog.trust.gui.ImportCertificateDialog;
import ch.transsoft.edec.util.NumberUtil;
import ch.transsoft.edec.util.SystemUtil;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import nl.altindag.ssl.SSLFactory;

public class ConnectionService
implements IConnectionService {
    private final ProxySelector defaultSelector = ProxySelector.getDefault();

    @Override
    public void init() {
        this.registerListener();
        this.configureSSLContext();
        this.setProxy();
    }

    private void configureSSLContext() {
        SSLFactory sslFactory = SSLFactory.builder().withDefaultTrustMaterial().withSystemTrustMaterial().withTrustMaterial(new RootImportInflatableTrustManager(new File(new File(new File(SystemUtil.getUserHomeDir(), ".transsoft"), "expovit"), "custom-cacerts").toPath(), "changeit".toCharArray(), "JKS", params -> {
            X509Certificate[] chain = params.getChain();
            return ImportCertificateDialog.showCertificateImportDialog(List.of(chain));
        })).build();
        SSLContext.setDefault(sslFactory.getSslContext());
    }

    private void registerListener() {
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                ConnectionService.this.setProxy();
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void rootChanged() {
            }
        });
    }

    private void setProxy() {
        ProxyInfo info = Services.get(IConfigService.class).getProxyConfiguration().getProxyInfo();
        if (!info.getProxyHost().isEnabled()) {
            ProxySelector.setDefault(this.defaultSelector);
        } else if (info.getProxyHost().isUserProxySet()) {
            String port = info.getProxyHost().getHttpPort().getValue();
            if (!NumberUtil.isInteger(port)) {
                Services.get(ILoggingService.class).logAndReport(Services.getText(4427) + " " + port);
                return;
            }
            String host = info.getProxyHost().getHttpHost().getValue();
            Services.get(ILoggingService.class).logSilent("Using custom proxy host: " + host + ":" + port);
            ProxySelector.setDefault(new CustomProxySelector(host, NumberUtil.parseInteger(port)));
        }
        if (info.getProxyAuth().isEnabled()) {
            String user = info.getProxyAuth().getUser().getValue();
            String password = info.getProxyAuth().getPassword().getValue();
            Authenticator.setDefault(new ProxyAuthenticator(user, password));
        } else {
            Authenticator.setDefault(null);
        }
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final String user;
        private final String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

