/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.text.internal;

import ch.transsoft.edec.service.text.data.ResourceLocator;
import ch.transsoft.edec.service.text.internal.Text;
import ch.transsoft.edec.util.Check;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextLoader
extends DefaultHandler {
    private final Map<Integer, Text> texts;
    private Text currentText;
    private State currentState;
    private StringBuilder currentChars;

    public TextLoader(Map<Integer, Text> texts) {
        this.texts = texts;
    }

    public void load() {
        try {
            this.readFile("language.xml");
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    private void readFile(String fileName) throws Exception {
        InputStream inputStream = ResourceLocator.class.getResourceAsStream(fileName);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(inputStream, (DefaultHandler)this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (this.currentChars != null) {
            this.currentChars.append(value);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Root")) {
            return;
        }
        if (qName.equals("Row")) {
            this.currentText = new Text();
            return;
        }
        this.currentState = State.valueOf(qName);
        this.currentChars = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentState != null && this.currentChars != null) {
            this.currentState.handle(this.texts, this.currentText, this.currentChars.toString());
        }
        this.currentChars = null;
        this.currentState = null;
    }

    private static enum State {
        ID{

            @Override
            public void handle(Map<Integer, Text> texts, Text text, String value) {
                texts.put(Integer.parseInt(value), text);
            }
        }
        ,
        DE{

            @Override
            public void handle(Map<Integer, Text> texts, Text text, String value) {
                text.setDe(value);
            }
        }
        ,
        FR{

            @Override
            public void handle(Map<Integer, Text> texts, Text text, String value) {
                text.setFr(value);
            }
        }
        ,
        IT{

            @Override
            public void handle(Map<Integer, Text> texts, Text text, String value) {
                text.setIt(value);
            }
        }
        ,
        EN{

            @Override
            public void handle(Map<Integer, Text> texts, Text text, String value) {
                text.setEn(value);
            }
        };


        public abstract void handle(Map<Integer, Text> var1, Text var2, String var3);
    }
}

