/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.ErrorList;
import ch.transsoft.edec.service.validate.ErrorMarker;

public class GenericBasicValidator
implements ITraversal {
    private ErrorList errorList;

    @Override
    public void visit(IPrimitive<?> node) {
        if (node.isMandatory() && !node.isInitialized()) {
            this.errorList.add(new ErrorMarker("notNull", node, Services.getText(948)));
        }
    }

    @Override
    public boolean visitChildren(ModelNode<?> node) {
        return node.isMandatory() || node.isEnabled();
    }

    @Override
    public <T extends ListEntry<T>> void visit(ListNode<T> node) {
    }

    @Override
    public void visit(EnumNode<?> enumNode) {
    }

    public boolean validate(ModelNode<?> root) {
        if (this.errorList != null) {
            for (ErrorMarker current : this.errorList) {
                current.getNode().removeError();
            }
        }
        this.errorList = new ErrorList();
        root.traverse(this);
        for (ErrorMarker current : this.errorList) {
            current.getNode().setError(current);
        }
        return this.errorList.isEmpty();
    }
}

