/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate;

import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.State;
import ch.transsoft.edec.model.sending.forms.Forms;
import ch.transsoft.edec.model.sending.goodsdeclaration.GoodsDeclaration;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.validate.ErrorList;
import ch.transsoft.edec.service.validate.ErrorMarker;
import ch.transsoft.edec.util.Check;
import java.math.BigInteger;

public abstract class RuleBase {
    private Sending sending;
    private ErrorList errors;

    protected abstract void doValidate();

    public void validate(Sending sending, ErrorList errors) {
        Check.assertNotNull(errors);
        Check.assertNotNull(sending);
        this.errors = errors;
        this.sending = sending;
        this.doValidate();
    }

    protected void addError(INode<?> node, String message) {
        this.addError(this.getClass().getSimpleName(), node, message);
    }

    protected void addError(String errorId, INode<?> node, String message) {
        this.errors.add(new ErrorMarker(errorId, node, message));
    }

    protected Sending getSending() {
        return this.sending;
    }

    protected State getState() {
        return this.sending.getState();
    }

    protected Forms getForms() {
        return this.sending.getForms();
    }

    protected GoodsDeclaration getGoodsDeclaration() {
        return this.sending.getGoodsDeclaration();
    }

    protected ItemList getItemList() {
        return this.sending.getCustomsItemListIfPresent();
    }

    protected ListNode<GoodsItem> getGoodsItems() {
        return this.getItemList().getGoodsItems();
    }

    protected IPrimitive<?> getPrimitive(String path) {
        return (IPrimitive)this.sending.find(path);
    }

    protected boolean in(SelectionNode node, String ... values) {
        return node.in(values);
    }

    protected boolean isVeredelung(GoodsData data) {
        return data.getCustomsClearanceType().asInt() == 2;
    }

    protected boolean isAusbesserung(GoodsItem item) {
        return item.getRepairAndRefinement().getRepair().asBigInt().equals(BigInteger.ONE);
    }

    protected boolean isVerfahrenOrdentlich(GoodsItem current) {
        if (!current.getRepairAndRefinement().isEnabled()) {
            return false;
        }
        if (!current.getRepairAndRefinement().getProcessType().isInitialized()) {
            return false;
        }
        return current.getRepairAndRefinement().getProcessType().asInt() == 1;
    }

    protected boolean isHandelsware(GoodsData data) {
        return data.getCommercialGood().asInt() == 1;
    }
}

