/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate;

import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.validate.ErrorList;
import ch.transsoft.edec.service.validate.ErrorMarker;
import ch.transsoft.edec.service.validate.IValidateListener;
import ch.transsoft.edec.service.validate.IValidateService;
import ch.transsoft.edec.service.validate.rules.Validator;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.File;

public class ValidateService
implements IValidateService {
    private ErrorList errorList;
    private ListenerList<IValidateListener> listeners = new ListenerList();
    private Validator validator = new Validator();

    public ValidateService() {
        Services.get(IAppService.class).addChangeListener(new IAppChangedListener(){

            @Override
            public void sendingChanged(Sending sending) {
                ValidateService.this.errorList = null;
            }

            @Override
            public void stateChanged(AppState state, File template) {
            }
        });
    }

    @Override
    public IDisposable add(IValidateListener listener) {
        return this.listeners.add(listener);
    }

    public void notifyValidateListener(boolean value) {
        for (IValidateListener listener : this.listeners) {
            listener.currentSendingValid(value);
        }
    }

    @Override
    public boolean validate(boolean forSending) {
        Services.get(IAppService.class).getCurrentSending().applyDefaults();
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        if (this.errorList != null) {
            for (ErrorMarker current : this.errorList) {
                current.getNode().removeError();
            }
        }
        this.errorList = this.validator.computeErrors(sending, forSending);
        this.notifyValidateListener(this.errorList.isEmpty());
        for (ErrorMarker current : this.errorList) {
            current.getNode().setError(current);
        }
        boolean noErrors = this.errorList.isEmpty();
        if (sending.getState().getAlState() != ALState.complete) {
            sending.getState().setAlState(noErrors ? ALState.validated : ALState.error);
        }
        return noErrors;
    }

    @Override
    public void addError(ErrorMarker errorMarker) {
        Check.checkEDT();
        this.errorList.add(errorMarker);
        errorMarker.getNode().setError(errorMarker);
    }
}

