/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate.rules;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.RuleBase;
import ch.transsoft.edec.util.DateUtil;
import java.util.Date;

public class CheckDates
extends RuleBase
implements ITraversal {
    private static final Date DATE_SENTINEL = DateUtil.getDate("9999-12-31");

    @Override
    public void doValidate() {
        this.getSending().traverse(this);
    }

    @Override
    public void visit(IPrimitive<?> node) {
        if (!(node instanceof DateNode)) {
            return;
        }
        if (!node.isInitialized()) {
            return;
        }
        Date date = ((DateNode)node).getValue();
        if (date.after(DATE_SENTINEL)) {
            this.addError(node, Services.getText(953));
        }
    }

    @Override
    public boolean visitChildren(ModelNode<?> node) {
        return node.isMandatory() || node.isEnabled();
    }

    @Override
    public <T extends ListEntry<T>> void visit(ListNode<T> node) {
    }

    @Override
    public void visit(EnumNode<?> enumNode) {
    }
}

