/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.validate.rules;

import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.validate.rules.GoodsItemRuleBase;

public class RepairMigrationValidation
extends GoodsItemRuleBase {
    @Override
    protected void doValidate(GoodsItem itemBefore, GoodsItem item, GoodsData data) {
        if (!this.isAusbesserung(data)) {
            return;
        }
        if (item.getRepairAndRefinement().getRepair().asInt() == 0) {
            this.addError(item.getRepairAndRefinement().getRepair(), Services.getText(944));
        }
        this.checkIsInitialized(item.getRepairAndRefinement().getRepairReason());
        this.checkIsInitialized(item.getRepairAndRefinement().getDirection());
    }

    private void checkIsInitialized(IPrimitive<?> node) {
        if (!node.isInitialized()) {
            this.addError(node, Services.getText(944));
        }
    }

    protected boolean isAusbesserung(GoodsData data) {
        return data.getCustomsClearanceType().asInt() == 3;
    }
}

