/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.webservices;

import ch.transsoft.edec.service.webservices.LicenseAlreadyBoughtException;
import ch.transsoft.edec.service.webservices.RestOperation;
import ch.transsoft.edec.service.webservices.UnknownCustomsDeclarationNumberException;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import org.openapitools.client.ApiException;

public final class RestUtil {
    private static final String UNKNOWN_GUID_EXCEPTION = "UnknownGuid";
    private static final String LICENSE_ALREADY_BOUGHT = "LicenseAlreadyBought";
    private static final String UNKNOWN_CUSTOM_DECLARATION = "UnknownCustomsDeclarationNumber";

    public static <T> T executeAndHandleUnknownGuid(RestOperation<T> operation) throws UnknownGuidException {
        try {
            return operation.apply();
        }
        catch (ApiException e2) {
            String body;
            if (e2.getCode() == 400 && (body = e2.getResponseBody()).equals(UNKNOWN_GUID_EXCEPTION)) {
                throw new UnknownGuidException();
            }
            throw new RuntimeException("REST exception", e2);
        }
    }

    public static <T> T executeAndHandleUnknownGuidAndUnknownCustomDeclaration(RestOperation<T> operation) throws UnknownGuidException, UnknownCustomsDeclarationNumberException {
        try {
            return operation.apply();
        }
        catch (ApiException e2) {
            if (e2.getCode() == 400) {
                String body = e2.getResponseBody();
                if (body.equals(UNKNOWN_GUID_EXCEPTION)) {
                    throw new UnknownGuidException();
                }
                if (body.equals(UNKNOWN_CUSTOM_DECLARATION)) {
                    throw new UnknownCustomsDeclarationNumberException();
                }
            }
            throw new RuntimeException("REST exception", e2);
        }
    }

    public static void executeAndHandleUnknownGuidAndLicenseAlreadyBought(RestOperation<Void> operation) throws UnknownGuidException, LicenseAlreadyBoughtException {
        try {
            operation.apply();
        }
        catch (ApiException e2) {
            if (e2.getCode() == 400) {
                String body = e2.getResponseBody();
                if (body.equals(UNKNOWN_GUID_EXCEPTION)) {
                    throw new UnknownGuidException();
                }
                if (body.equals(LICENSE_ALREADY_BOUGHT)) {
                    throw new LicenseAlreadyBoughtException();
                }
            }
            throw new RuntimeException("REST exception", e2);
        }
    }

    public static <T> T execute(RestOperation<T> operation) {
        try {
            return operation.apply();
        }
        catch (Exception e2) {
            throw new RuntimeException("REST exception", e2);
        }
    }
}

