/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.action;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.LockedActionBase;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import java.awt.event.ActionEvent;
import java.io.File;

public class CreateSendingAction
extends LockedActionBase {
    public CreateSendingAction() {
        super(Services.getText(3003), CreateSendingAction.getIcon("icon/sending-small.png"), CreateSendingAction.getIcon("icon/sending-big.png"));
        this.addStateListener();
        this.updateState();
        this.disableForModuleImport(Services.getText(3004));
    }

    private void addStateListener() {
        this.add(Services.get(IAppService.class).addChangeListener(new IAppChangedListener(){

            @Override
            public void sendingChanged(Sending sending) {
                CreateSendingAction.this.updateState();
            }

            @Override
            public void stateChanged(AppState state, File template) {
                CreateSendingAction.this.updateState();
            }
        }));
    }

    @Override
    protected void updateState() {
        switch (Services.get(IAppService.class).getAppState()) {
            case newSending: {
                this.setEnabled(false);
                break;
            }
            case sending: {
                this.setEnabled(false);
                break;
            }
            case template: {
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String templateName = Services.get(IAppService.class).getCurrentTemplate().getName();
        Services.get(IAppService.class).saveSendingFirstTime("Created from template " + templateName);
    }
}

