/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.action;

import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.LockedActionBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.UpdateBordereauStateJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.AddReceiptFromFileJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileChooserUtil;
import ch.transsoft.edec.util.FileUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;

public class EvvFileImportForModuleImportAction
extends LockedActionBase {
    public EvvFileImportForModuleImportAction() {
        super(Services.getText(4900));
        this.disableIfNoImportLicense(4900);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileNode lastImportFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getReceiptFileImportFolder();
        File[] files = FileChooserUtil.chooseFiles(lastImportFolder.getValue(), Services.getText(4901), null, null, "XML");
        if (files.length == 0) {
            return;
        }
        lastImportFolder.setValue(files[0].getParentFile());
        Services.get(IConfigService.class).savePreferences();
        Services.get(IGuiService.class).selectImportTab(GuiService.ImportTab.receipts, null);
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                this.readEvv(file);
            }
            catch (Exception e2) {
                Services.get(ILoggingService.class).logAndReport(e2, Services.getText(4902));
            }
        }
        Services.get(IBackendService.class).put(new UpdateBordereauStateJob(), true);
    }

    private void readEvv(File file) throws IOException {
        Document doc;
        try {
            doc = DocumentUtil.readXmlDoc(file);
        }
        catch (Exception e2) {
            DialogUtil.showWarningDialog(Services.getText(600), Services.getText(4902) + ": " + String.valueOf(file) + "\n" + e2.getMessage());
            return;
        }
        String typeStr = DocumentUtil.getString(doc, "documentType");
        if (typeStr == null) {
            DialogUtil.showWarningDialog(Services.getText(600), Services.getText(4903) + ": " + String.valueOf(file));
            return;
        }
        ReceiptDocumentType type = ReceiptDocumentType.getReceiptDocumentType(typeStr);
        if (type == null) {
            DialogUtil.showWarningDialog(Services.getText(600), Services.getText(4903) + ": " + String.valueOf(file));
            return;
        }
        byte[] data = FileUtil.getFileAsByteArray(file);
        Services.get(IBackendService.class).put(new AddReceiptFromFileJob(doc, data, type), true);
    }
}

