/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.action;

import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.LockedActionBase;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.SendAzaJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.validate.IValidateService;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Icon;

public class SendAzaAction
extends LockedActionBase {
    private static final Icon ezv;
    private static final Icon ezv_test;

    public SendAzaAction() {
        super(Services.getText(307), SendAzaAction.getIcon("icon/ezv-small.png"), ezv);
        this.addEnablingListener();
        this.addSendingChangeListener();
        this.updateEnabling();
    }

    private void addSendingChangeListener() {
        this.add(Services.get(IAppService.class).addChangeListener(new IAppChangedListener(){

            @Override
            public void sendingChanged(Sending sending) {
                SendAzaAction.this.updateEnabling();
            }

            @Override
            public void stateChanged(AppState state, File template) {
                SendAzaAction.this.updateEnabling();
            }
        }));
    }

    private void addEnablingListener() {
        this.add(this.getConfigService().add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
            }

            @Override
            public void modeChanged(boolean isDemo) {
                SendAzaAction.this.updateEnabling();
            }

            @Override
            public void configurationChanged() {
                SendAzaAction.this.updateEnabling();
            }
        }));
    }

    private void updateEnabling() {
        if (this.getAppService().getAppState() == AppState.newSending) {
            this.setEnabled(false);
            this.setTooltip(Services.getText(3036));
            return;
        }
        if (this.getAppService().getAppState() == AppState.template) {
            this.setEnabled(false);
            this.setTooltip(Services.getText(3037));
            return;
        }
        if (!this.getConfigService().hasCertificate()) {
            this.setEnabled(false);
            this.setTooltip(Services.getText(3038));
            return;
        }
        OperatingMode systemMode = this.getConfigService().getOperatingModeForActiveModule();
        OperatingMode sendingMode = this.getCurrentSending().getState().getOperatingMode();
        if (systemMode == OperatingMode.production && sendingMode == OperatingMode.test) {
            this.setEnabled(false);
            this.setTooltip(Services.format(3039, 3040));
            return;
        }
        if (systemMode == OperatingMode.test && sendingMode == OperatingMode.production) {
            this.setEnabled(false);
            this.setTooltip(Services.format(3039, 3041));
            return;
        }
        this.setEnabled(true);
        if (systemMode == OperatingMode.production) {
            this.setTooltip(Services.format(3042, 3041));
            this.putValue("SwingLargeIconKey", ezv);
        } else {
            this.setTooltip(Services.format(3042, 3040));
            this.putValue("SwingLargeIconKey", ezv_test);
        }
    }

    private Sending getCurrentSending() {
        return Services.get(IAppService.class).getCurrentSending();
    }

    private IAppService getAppService() {
        return Services.get(IAppService.class);
    }

    private IConfigService getConfigService() {
        return Services.get(IConfigService.class);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (!Services.get(IValidateService.class).validate(true)) {
            return;
        }
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        Services.get(IBackendService.class).put(new SendAzaJob(sending));
    }

    static {
        ezv_test = ezv = SendAzaAction.getIcon("icon/ezv-big.png");
    }
}

