/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.action;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.LockedActionBase;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.validate.IValidateService;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.awt.event.ActionEvent;
import java.io.File;

public class ValidateAction
extends LockedActionBase {
    private IDisposable disposable;

    public ValidateAction() {
        super(Services.getText(3046));
        this.setIconQuestion();
        this.setTooltip(Services.getText(3046));
        this.addSendingChangeListener();
        this.updateState();
        this.addValidateListener();
        this.addSendingListener(Services.get(IAppService.class).getCurrentSending());
    }

    private void addSendingListener(Sending sending) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.disposable = sending.addChangeListener((source, info) -> {
            if (source != null && source.isFieldName("alState")) {
                return;
            }
            this.setIconQuestion();
        });
    }

    private void addSendingChangeListener() {
        this.add(Services.get(IAppService.class).addChangeListener(new IAppChangedListener(){

            @Override
            public void sendingChanged(Sending sending) {
                ValidateAction.this.addSendingListener(sending);
                ValidateAction.this.setIconQuestion();
            }

            @Override
            public void stateChanged(AppState state, File template) {
                ValidateAction.this.updateState();
            }
        }));
    }

    @Override
    protected void updateState() {
        switch (Services.get(IAppService.class).getAppState()) {
            case sending: {
                this.setEnabled(true);
                this.setTooltip(Services.getText(3046));
                break;
            }
            case newSending: {
                this.setEnabled(false);
                this.setTooltip(Services.getText(3036));
                break;
            }
            case template: {
                this.setEnabled(false);
                this.setTooltip(Services.getText(3037));
            }
        }
    }

    private void addValidateListener() {
        Services.get(IValidateService.class).add((boolean value) -> {
            if (value) {
                this.setIconValid();
            } else {
                this.setIconInvalid();
            }
        });
    }

    private void setIconQuestion() {
        this.putValue("SwingLargeIconKey", ValidateAction.getIcon("icon/Check-big.png"));
        this.putValue("SmallIcon", ValidateAction.getIcon("icon/Check-small.png"));
    }

    private void setIconValid() {
        this.putValue("SwingLargeIconKey", ValidateAction.getIcon("icon/Check-green-big.png"));
        this.putValue("SmallIcon", ValidateAction.getIcon("icon/Check-small.png"));
    }

    private void setIconInvalid() {
        this.putValue("SwingLargeIconKey", ValidateAction.getIcon("icon/Check-red-big.png"));
        this.putValue("SmallIcon", ValidateAction.getIcon("icon/Check-small.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Services.get(IValidateService.class).validate(false);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }
}

