/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvexport.pm;

import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.SafeTransactionReporter;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.aza.AzaResponse;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvExportHandle;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvPm;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.SendingBuilder;
import ch.transsoft.edec.util.Check;
import java.util.List;
import javax.swing.SwingWorker;

public class EvvFetcher
extends SwingWorker<Void, EvvFetchingUpdate> {
    private final EvvPm evvPm;
    private final List<EvvExportHandle> handles;

    public EvvFetcher(EvvPm evvPm, List<EvvExportHandle> handles) {
        this.evvPm = evvPm;
        this.handles = handles;
    }

    @Override
    protected void done() {
        this.evvPm.finishFetchingEvv();
        if (this.isCancelled()) {
            return;
        }
        try {
            this.get();
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    @Override
    protected void process(List<EvvFetchingUpdate> chunks) {
        if (this.isCancelled()) {
            return;
        }
        for (EvvFetchingUpdate update : chunks) {
            this.evvPm.handle(update);
        }
    }

    @Override
    protected Void doInBackground() {
        for (EvvExportHandle handle : this.handles) {
            if (this.isCancelled()) {
                return null;
            }
            this.createSending(handle);
        }
        return null;
    }

    private void createSending(EvvExportHandle handle) {
        EvvResponse evv = this.fetchEvv(handle);
        if (this.isCancelled()) {
            return;
        }
        Sending sending = new SendingBuilder().create(evv.getResponse().getTaxationDecisionExport());
        sending.getState().setOperatingMode(this.evvPm.getMode());
        sending.getState().setEvvState(EVVState.complete);
        sending.addHistoryEntry("Created from eVV");
        AzaResponse al = this.fetchEvv(handle, sending);
        this.handleAl(sending, al);
        if (this.isCancelled()) {
            return;
        }
        EvvFetchingUpdate result = new EvvFetchingUpdate();
        result.setSendingEntry(sending, evv, al);
        this.publish(result);
        String guid = Services.get(IConfigService.class).getGuid();
        SafeTransactionReporter.saveReportTransactionExport(guid, sending.getCustomsDeclarationNumber(), 2, this.evvPm.getMode() == OperatingMode.production);
    }

    private void handleAl(Sending sending, AzaResponse al) {
        if (al == null) {
            return;
        }
        sending.getState().setAlState(ALState.complete);
        if (al.getStatus() != null) {
            sending.getState().setStatus(al.getStatus().getStatus().intValue());
        }
    }

    private AzaResponse fetchEvv(EvvExportHandle handle, Sending sending) {
        this.message(Services.getText(4708) + " " + handle.getCustomsDeclarationNumber());
        ModelNode transfer = sending.getCopy((ModelNode)null);
        ((Sending)transfer).getGoodsDeclaration().getCorrectionCode().setValue("3");
        ((Sending)transfer).getGoodsDeclaration().getCorrectionReason().clear();
        try {
            return Services.get(IEZVService.class).sendAza((Sending)transfer);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private EvvResponse fetchEvv(EvvExportHandle handle) {
        this.message(Services.getText(4709) + " " + handle.getCustomsDeclarationNumber());
        try {
            return Services.get(IEZVService.class).getEvv(this.evvPm.getMode(), this.evvPm.getUid(), handle.getCustomsDeclarationNumber(), null, ReceiptDocumentType.vve);
        }
        catch (Exception e2) {
            new FetchEvvJobErrorHandler(false).handleError(e2);
            this.cancel(false);
            return null;
        }
    }

    private void message(String string) {
        EvvFetchingUpdate update = new EvvFetchingUpdate();
        update.setMessage(string);
        this.publish(update);
    }
}

