/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvexport.pm;

import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.sending.CreateSendingFromSendingEntry;
import ch.transsoft.edec.service.backend.jobs.sending.SendingEntry;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvExportHandle;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvFetcher;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.EvvListPm;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.ListFetcher;
import ch.transsoft.edec.ui.dialog.evv.evvexport.pm.ListFetchingUpdate;
import ch.transsoft.edec.ui.gui.control.table.ToolTipJXTable;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.DateUtil;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.ListSelectionModel;

public class EvvPm
implements IPm {
    private final OperatingMode mode;
    private final String uid;
    private final ToolTipJXTable table;
    private final EvvListPm listPm;
    private final JDateChooser from;
    private final JDateChooser to;
    private final JButton fetchingListButton;
    private final JButton createSendingsButton;
    private final JLabel statusLabel;
    private final Component progressBar;
    private volatile ListFetcher listFetchWorker;
    private volatile EvvFetcher evvFetchWorker;

    public EvvPm(OperatingMode mode, String uid) {
        this.mode = mode;
        this.uid = uid;
        this.listPm = new EvvListPm();
        Date toDate = new Date();
        this.to = new JDateChooser();
        this.to.setDate(toDate);
        Date fromDate = DateUtil.getDateOffset(toDate, -30);
        this.from = new JDateChooser();
        this.from.setDate(fromDate);
        this.fetchingListButton = new JButton(Services.getText(4701));
        this.createSendingsButton = new JButton(Services.getText(4702));
        this.createSendingsButton.setEnabled(false);
        this.createSendingsButton.setToolTipText(Services.getText(4712));
        this.progressBar = this.createProgressBar();
        this.statusLabel = new JLabel();
        this.hideStatusInfo();
        this.table = new ToolTipJXTable();
        this.addButtonListeners();
        this.addTableSelectionListeners();
    }

    private void addTableSelectionListeners() {
        this.table.getSelectionModel().addListSelectionListener(e2 -> {
            if (e2.getValueIsAdjusting()) {
                return;
            }
            if (this.evvFetchWorker == null) {
                this.updateSendingButtonLabel();
            }
        });
    }

    private ArrayList<EvvExportHandle> getSelectedRows() {
        ArrayList<EvvExportHandle> result = new ArrayList<EvvExportHandle>();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        for (int i2 = selectionModel.getMinSelectionIndex(); i2 <= selectionModel.getMaxSelectionIndex(); ++i2) {
            if (!selectionModel.isSelectedIndex(i2)) continue;
            result.add(this.getListPm().getList().get(this.table.convertRowIndexToModel(i2)));
        }
        return result;
    }

    private void addButtonListeners() {
        this.fetchingListButton.addActionListener(e2 -> {
            if (this.listFetchWorker != null) {
                this.listFetchWorker.cancel(true);
                return;
            }
            this.fetchList();
        });
        this.createSendingsButton.addActionListener(e2 -> {
            if (this.evvFetchWorker != null) {
                this.evvFetchWorker.cancel(true);
                return;
            }
            this.fetchEvv();
        });
    }

    private void fetchEvv() {
        this.startFetchingEvv();
        this.evvFetchWorker = new EvvFetcher(this, this.getSelectedRows());
        this.evvFetchWorker.execute();
    }

    private void fetchList() {
        if (!this.rangeValid()) {
            DialogUtil.showWarningDialog(Services.getText(4706), Services.getText(4707));
            return;
        }
        this.listPm.clear();
        this.startFetchingList();
        this.listFetchWorker = new ListFetcher(this);
        this.setStatusInfo(Services.getText(865));
        this.listFetchWorker.execute();
    }

    private boolean rangeValid() {
        if (this.getFromDate() == null) {
            return false;
        }
        if (this.getToDate() == null) {
            return false;
        }
        return this.getFromDate().compareTo(this.getToDate()) <= 0;
    }

    public Date getFromDate() {
        if (this.from.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.from.getDate());
    }

    public Date getToDate() {
        if (this.to.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.to.getDate());
    }

    public Component getFrom() {
        return this.from;
    }

    public Component getTo() {
        return this.to;
    }

    public Component getFetchingListButton() {
        return this.fetchingListButton;
    }

    public Component getCreateSendingsButton() {
        return this.createSendingsButton;
    }

    public EvvListPm getListPm() {
        return this.listPm;
    }

    public OperatingMode getMode() {
        return this.mode;
    }

    public String getUid() {
        return this.uid;
    }

    private JProgressBar createProgressBar() {
        JProgressBar result = new JProgressBar();
        result.setIndeterminate(true);
        return result;
    }

    public void hideStatusInfo() {
        this.statusLabel.setVisible(false);
        this.progressBar.setVisible(false);
    }

    public void setStatusInfo(String text) {
        this.statusLabel.setText("<html>" + text + "</html>");
        this.statusLabel.setVisible(true);
        this.progressBar.setVisible(true);
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public Component getProgressBar() {
        return this.progressBar;
    }

    private void startFetchingEvv() {
        this.fetchingListButton.setEnabled(false);
        this.createSendingsButton.setText(Services.getText(208));
        this.table.setEnabled(false);
    }

    public void finishFetchingEvv() {
        this.evvFetchWorker = null;
        this.updateSendingButtonLabel();
        this.fetchingListButton.setEnabled(true);
        this.table.setEnabled(true);
        this.hideStatusInfo();
    }

    public void finishFetchingList() {
        this.listFetchWorker = null;
        this.fetchingListButton.setText(Services.getText(4701));
        this.createSendingsButton.setEnabled(true);
        this.hideStatusInfo();
    }

    private void startFetchingList() {
        this.fetchingListButton.setText(Services.getText(208));
        this.createSendingsButton.setEnabled(false);
    }

    public void handle(EvvFetchingUpdate update) {
        if (update.getMessage() != null) {
            this.setStatusInfo(update.getMessage());
        }
        if (update.getSendingEntry() != null) {
            this.addSending(update.getSendingEntry());
        }
    }

    private void addSending(SendingEntry sendingEntry) {
        Services.get(IBackendService.class).put(new CreateSendingFromSendingEntry(sendingEntry), true);
        this.listPm.updateSendingCreated(sendingEntry.sending.getGoodsDeclaration().getCustomsDeclarationNumber().getValue());
    }

    public void handle(ListFetchingUpdate update) {
        if (update.getMessage() != null) {
            this.setStatusInfo(update.getMessage());
        }
        if (update.getEvvHandles() != null) {
            this.addEntries(update.getEvvHandles());
        }
    }

    private void addEntries(List<EvvExportHandle> evvExportHandles) {
        for (EvvExportHandle current : evvExportHandles) {
            this.listPm.addRow(current);
        }
        if (this.listPm.getRowCount() > 0) {
            this.table.getSelectionModel().addSelectionInterval(0, this.listPm.getRowCount() - 1);
        }
    }

    private void updateSendingButtonLabel() {
        ArrayList<EvvExportHandle> result = this.getSelectedRows();
        if (result.isEmpty()) {
            this.createSendingsButton.setText(Services.getText(4702));
            this.createSendingsButton.setEnabled(false);
            this.createSendingsButton.setToolTipText(null);
        } else {
            this.createSendingsButton.setText(result.size() + " " + Services.getText(4702));
            this.createSendingsButton.setEnabled(true);
        }
    }

    public ToolTipJXTable getTable() {
        return this.table;
    }
}

