/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvexport.pm;

import ch.e_dec.xml.schema.edecreceiptresponse.v3.ContainerType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.DeclarantType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.GoodsItemType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.PackagingType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.PermitType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ProducedDocumentType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.RefundType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.RepairAndRefinementType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.SpecialMentionType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.TaxationDecisionExportType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.TransportMeansType;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TimestampNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.Carrier;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.model.sending.goodsdeclaration.Container;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.model.sending.goodsdeclaration.SpecialMentionHeader;
import ch.transsoft.edec.model.sending.goodsdeclaration.TransportMeans;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permit;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.ProducedDocument;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.RepairAndRefinement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class SendingBuilder {
    private Sending sending;

    public Sending create(TaxationDecisionExportType evv) {
        this.sending = NodeFactory.create(Sending.class);
        this.sending.getGoodsDeclaration().getCustomsDeclarationNumber().setValue(evv.getDocumentInformation().getDocumentNumber());
        this.sending.getGoodsDeclaration().getCustomsDeclarationVersion().setValue(evv.getDocumentInformation().getDocumentVersion().longValue());
        this.setDate(this.sending.getCreationDate(), evv.getAcceptanceDate());
        this.setDate(this.sending.getAcceptanceDate(), evv.getAcceptanceDate());
        this.setString(this.sending.getGoodsDeclaration().getTraderDeclarationNumber(), evv.getTraderDeclarationNumber());
        this.setString(this.sending.getGoodsDeclaration().getTraderReference(), evv.getTraderReference());
        this.setSelection(this.sending.getGoodsDeclaration().getDeclarationType(), evv.getDeclarationType());
        this.setSelection(this.sending.getGoodsDeclaration().getCorrectionCode(), evv.getCorrectionCode());
        this.setSelection(this.sending.getGoodsDeclaration().getCorrectionReason(), evv.getReason());
        this.setSelection(this.sending.getGoodsDeclaration().getDeliveryDestination(), evv.getDeliveryDestination());
        this.setString(this.sending.getGoodsDeclaration().getConsignor().getVatNumber(), evv.getVATNumber());
        this.addTransportMeans(this.sending.getGoodsDeclaration().getTransportMeans(), evv.getTransportMeans());
        this.addContainers(this.sending.getGoodsDeclaration().getContainers(), evv.getContainer());
        this.addSpecialMentions(this.sending.getGoodsDeclaration().getSpecialMentions(), evv.getSpecialMention());
        this.addConsignor(this.sending.getGoodsDeclaration().getConsignor(), evv.getConsignor());
        this.addConsignee(this.sending.getGoodsDeclaration().getConsignee(), evv.getConsignee());
        this.addCarrier(this.sending.getGoodsDeclaration().getCarrier(), evv.getCarrier());
        this.addDeclarant(this.sending.getGoodsDeclaration().getDeclarant(), evv.getDeclarant());
        this.sending.getGoodsDeclaration().getBusiness().getIncoterms().setValue("EXW");
        for (GoodsItemType item : evv.getGoodsItem()) {
            this.sending.getItemList().getGoodsItems().add(this.createGoodsItem(item));
        }
        return this.sending;
    }

    private GoodsItem createGoodsItem(GoodsItemType item) {
        GoodsItem result = NodeFactory.create(GoodsItem.class);
        this.setInteger(result.getGoodsData().getTraderItemID(), item.getCustomsItemNumber());
        this.setString(result.getGoodsData().getDescriptionShort(), item.getDescription());
        this.setString(result.getGoodsData().getCommodityCode(), item.getCommodityCode());
        this.setBoolean(result.getConfirmation().getCommodityCodeConfirmation(), item.getCommodityCodeConfirmation());
        this.setInteger(result.getGoodsData().getStatisticalCode(), item.getStatisticalCode());
        this.setDecimal(result.getGoodsData().getGrossMass(), item.getGrossMass());
        this.setDecimal(result.getGoodsData().getNetMass(), item.getNetMass());
        this.setDecimal(result.getGoodsData().getAdditionalUnit(), item.getAdditionalUnit());
        this.setStatisticalValue(result.getGoodsData(), item);
        this.setBoolean(result.getConfirmation().getStatisticalValueConfirmation(), item.getStatistic().getStatisticalValueConfirmation());
        this.setSelection(result.getGoodsData().getCommercialGood(), item.getStatistic().getCommercialGood());
        this.addRefund(result.getGoodsData(), item.getRefund());
        this.addRepairAndRefinement(result.getRepairAndRefinement(), item.getRepairAndRefinement());
        this.addPackaging(result.getGoodsData(), item.getPackaging());
        for (ProducedDocumentType doc : item.getProducedDocument()) {
            result.getProducedDocuments().add(this.createProducedDocument(doc));
        }
        for (PermitType permit : item.getPermit()) {
            result.getPermits().getPermitList().add(this.createPermit(permit));
        }
        return result;
    }

    private void setStatisticalValue(GoodsData goodsData, GoodsItemType item) {
        this.setDecimal(goodsData.getStatisticalValue(), item.getStatistic().getStatisticalValue());
        this.setDecimal(goodsData.getStatisticalValueChf(), item.getStatistic().getStatisticalValue());
        goodsData.getCurrency().setValue("CHF");
        goodsData.getCurrencyRate().setValue(1.0);
    }

    private void addRefund(GoodsData t, RefundType s) {
        if (s == null) {
            return;
        }
        this.setSelection(t.getRefundType(), s.getRefundType());
        this.setDecimal(t.getVOCQuantity(), s.getVOCQuantity());
    }

    private Permit createPermit(PermitType s) {
        Permit result = NodeFactory.create(Permit.class);
        this.setSelection(result.getPermitType(), s.getPermitType());
        this.setSelection(result.getPermitAuthority(), s.getPermitAuthority());
        this.setString(result.getPermitNumber(), s.getPermitNumber());
        this.setDate(result.getIssueDate(), s.getIssueDate());
        this.setString(result.getAdditionalInformation(), s.getAdditionalInformation());
        return result;
    }

    private ProducedDocument createProducedDocument(ProducedDocumentType s) {
        ProducedDocument result = NodeFactory.create(ProducedDocument.class);
        this.setSelection(result.getDocumentType(), s.getDocumentType());
        this.setString(result.getDocumentReferenceNumber(), s.getDocumentReferenceNumber());
        this.setDate(result.getIssueDate(), s.getIssueDate());
        this.setString(result.getAdditionalInformation(), s.getAdditionalInformation());
        return result;
    }

    private void addPackaging(GoodsData t, List<PackagingType> packaging) {
        PackagingType s = packaging.get(0);
        this.setInteger(t.getQuantity(), s.getQuantity());
        this.setSelection(t.getPackagingType(), s.getPackagingType());
        this.setString(t.getPackagingReferenceNumber(), s.getPackagingReferenceNumber());
    }

    private void addRepairAndRefinement(RepairAndRefinement t, RepairAndRefinementType s) {
        if (s == null) {
            return;
        }
        this.setSelection(t.getDirection(), s.getDirection());
        this.setSelection(t.getRefinementType(), s.getRefinementType());
        this.setSelection(t.getProcessType(), s.getProcessType());
        this.setSelection(t.getBillingType(), s.getBillingType());
    }

    private void addConsignor(Consignor t, TaxationDecisionExportType.Consignor s) {
        this.setString(t.getId(), s.getConsignorReference());
        this.setString(t.getName(), s.getName());
        this.setString(t.getAddressSupplement1(), s.getAddressSupplement1());
        this.setString(t.getAddressSupplement2(), s.getAddressSupplement2());
        this.setString(t.getStreet(), s.getStreet());
        this.setString(t.getPostalCode(), s.getPostalCode());
        this.setString(t.getCity(), s.getCity());
        this.setSelection(t.getCountry(), s.getCountry());
        this.setString(t.getUid(), s.getTraderIdentificationNumber());
    }

    private void addConsignee(Address t, TaxationDecisionExportType.Consignee s) {
        this.setString(t.getId(), s.getConsigneeReference());
        this.setString(t.getName(), s.getName());
        this.setString(t.getAddressSupplement1(), s.getAddressSupplement1());
        this.setString(t.getAddressSupplement2(), s.getAddressSupplement2());
        this.setString(t.getStreet(), s.getStreet());
        this.setString(t.getPostalCode(), s.getPostalCode());
        this.setString(t.getCity(), s.getCity());
        this.setSelection(t.getCountry(), s.getCountry());
    }

    private void addCarrier(Carrier t, TaxationDecisionExportType.Carrier s) {
        if (s == null) {
            return;
        }
        this.setString(t.getId(), s.getCarrierReference());
        this.setString(t.getName(), s.getName());
        this.setString(t.getAddressSupplement1(), s.getAddressSupplement1());
        this.setString(t.getAddressSupplement2(), s.getAddressSupplement2());
        this.setString(t.getStreet(), s.getStreet());
        this.setString(t.getPostalCode(), s.getPostalCode());
        this.setString(t.getCity(), s.getCity());
        this.setSelection(t.getCountry(), s.getCountry());
    }

    private void addDeclarant(Declarant t, DeclarantType s) {
        this.setInteger(t.getDeclarantNumber(), s.getDeclarantNumber());
        this.setString(t.getDeclarantName(), s.getName());
        this.setString(t.getStreet(), s.getStreet());
        this.setString(t.getPostalCode(), s.getPostalCode());
        this.setString(t.getCity(), s.getCity());
        this.setSelection(t.getCountry(), s.getCountry());
    }

    private void addSpecialMentions(ListNode<SpecialMentionHeader> s, List<SpecialMentionType> sm) {
        for (SpecialMentionType current : sm) {
            SpecialMentionHeader mention = NodeFactory.create(SpecialMentionHeader.class);
            this.setString(mention.getText(), current.getText());
            s.add(mention);
        }
    }

    private void addContainers(ListNode<Container> containers, List<ContainerType> c2) {
        for (ContainerType current : c2) {
            Container container = NodeFactory.create(Container.class);
            this.setString(container.getContainerNumber(), current.getContainerNumber());
            containers.add(container);
        }
    }

    private void addTransportMeans(TransportMeans tm, TransportMeansType t) {
        this.setSelection(tm.getTransportMode(), t.getTransportMode());
        this.setSelection(tm.getTransportationCountry(), t.getTransportationCountry());
        this.setString(tm.getTransportationNumber(), t.getTransportationNumber());
    }

    private void setSelection(SelectionNode target, String source) {
        if (source == null) {
            return;
        }
        target.setValue(target.getDomainData().get(source), false);
    }

    private void setSelection(SelectionNode target, BigInteger source) {
        if (source == null) {
            return;
        }
        target.setValue(target.getDomainData().get(source.toString()), false);
    }

    private void setString(StringNode target, String source) {
        if (source == null) {
            return;
        }
        target.setValue(source);
    }

    private void setInteger(IntegralNode target, BigInteger source) {
        if (source == null) {
            return;
        }
        target.setValue(source.longValue());
    }

    private void setDate(TimestampNode target, XMLGregorianCalendar source) {
        if (source == null) {
            return;
        }
        target.setValue(source.toGregorianCalendar().getTime(), false);
    }

    private void setDate(DateNode target, XMLGregorianCalendar source) {
        if (source == null) {
            return;
        }
        target.setValue(source.toGregorianCalendar().getTime(), false);
    }

    private void setBoolean(BooleanNode target, BigInteger source) {
        if (source == null) {
            return;
        }
        target.setValue(source.intValue() == 1);
    }

    private void setDecimal(DecimalNode target, BigDecimal source) {
        if (source == null) {
            return;
        }
        target.setValue(source.doubleValue());
    }

    private void setDecimal(DecimalNode target, BigInteger source) {
        if (source == null) {
            return;
        }
        target.setValue(source.doubleValue());
    }
}

