/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvimport.pm;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.index.IArchiveChangeListener;
import ch.transsoft.edec.service.index.IIndexChangeListener;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ListFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptImportHandle;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import javax.swing.SwingWorker;

public class ListFetcher
extends SwingWorker<Void, ListFetchingUpdate> {
    private final ReceiptPm receiptPm;
    private final Map<ImportSendingKey, ReceiptEntry> sendings = new Hashtable<ImportSendingKey, ReceiptEntry>();
    private Semaphore semaphore;

    public ListFetcher(ReceiptPm receiptPm) {
        this.receiptPm = receiptPm;
        this.listSendings();
    }

    private void listSendings() {
        int fromYear = DateUtil.getYear(this.receiptPm.getFromDate()) - 1;
        int toYear = DateUtil.getYear(this.receiptPm.getToDate());
        HashSet<Integer> years = new HashSet<Integer>();
        for (int i2 = fromYear; i2 <= toYear; ++i2) {
            years.add(i2);
        }
        int permits = 1 + (-1 - years.size());
        this.semaphore = new Semaphore(permits);
        this.getIndexService().add(new IArchiveChangeListener<ReceiptEntry, ReceiptIndex>(){

            @Override
            public void clear() {
            }

            @Override
            public void changed(int year, ReceiptIndex archivePart) {
                ListFetcher.this.addSendings(archivePart);
                ListFetcher.this.semaphore.release();
            }
        });
        this.getIndexService().add(new IIndexChangeListener<ReceiptEntry, ReceiptIndex>(){

            @Override
            public void clear() {
            }

            @Override
            public void changed(ReceiptIndex newIndex) {
                ListFetcher.this.addSendings(newIndex);
                ListFetcher.this.semaphore.release();
            }
        });
        this.getIndexService().readIndex();
        this.getIndexService().readArchive(years);
    }

    private IReceiptService getIndexService() {
        return Services.get(IReceiptService.class);
    }

    @Override
    protected void done() {
        this.receiptPm.finishFetchingList();
        if (this.isCancelled()) {
            return;
        }
        try {
            this.get();
        }
        catch (ExecutionException e2) {
            Throwable cause = e2.getCause();
            new FetchEvvJobErrorHandler(false).handleError(cause);
        }
        catch (Exception e3) {
            Check.fail(e3);
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.semaphore.acquire();
        if (this.isCancelled()) {
            return null;
        }
        List<DateUtil.DateRange> ranges = DateUtil.getRanges(this.receiptPm.getFromDate(), this.receiptPm.getToDate(), 10);
        for (DateUtil.DateRange current : ranges) {
            this.publish(current);
            ArrayList<IEZVService.EvvImportListEntry> result = new ArrayList<IEZVService.EvvImportListEntry>();
            Services.get(IEZVService.class).getEvvListImport(this.receiptPm.getMode(), this.receiptPm.getImportID(), current.start, current.end, this.receiptPm.getSelectedZazAccount(), result);
            if (this.isCancelled()) {
                return null;
            }
            this.publish((List<IEZVService.EvvImportListEntry>)result);
        }
        return null;
    }

    private void publish(List<IEZVService.EvvImportListEntry> entries) {
        ArrayList<ReceiptImportHandle> handles = new ArrayList<ReceiptImportHandle>();
        for (IEZVService.EvvImportListEntry handle : entries) {
            ReceiptEntry receiptEntry = this.sendings.get(handle.getKey());
            if (receiptEntry == null) {
                handles.add(this.createEvvHandle(handle));
                continue;
            }
            try {
                if (this.containsVersion(receiptEntry, handle)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            handles.add(this.createEvvHandle(handle));
        }
        ListFetchingUpdate update = new ListFetchingUpdate();
        update.setEvvListEntries(handles);
        this.publish(update);
    }

    private boolean containsVersion(ReceiptEntry entry, IEZVService.EvvImportListEntry handle) throws Exception {
        if (entry.getDocState(handle.getReceiptDocumentType()) != ReceiptDocument.State.DOC_VALID) {
            return false;
        }
        File file = SendingUtil.getImportSendingListPathWithoutExtension(entry.getDate(), true);
        ImportSendingList importSendingList = FileUtil.readFile(file, ImportSendingList.class);
        ImportSending importSending = importSendingList.getImportSending(entry.getKey());
        if (importSending == null) {
            return false;
        }
        StringNode presentVersion = importSending.getDocumentVersion(handle.getReceiptDocumentType());
        if (!presentVersion.isInitialized()) {
            return false;
        }
        String fetchedVersion = handle.getCustomsDeclarationVersion().toString();
        return fetchedVersion.equals(presentVersion.getValue());
    }

    private ReceiptImportHandle createEvvHandle(IEZVService.EvvImportListEntry handle) {
        ReceiptImportHandle result = new ReceiptImportHandle();
        result.setEntry(null);
        result.setDate(handle.getDate());
        result.setCustomsDeclarationNumber(handle.getCustomsDeclarationNumber());
        result.setCustomsDeclarationVersion(handle.getCustomsDeclarationVersion());
        result.setConsignee(handle.getConsignee());
        result.setAccount(handle.getAccount());
        result.setType(handle.getType());
        return result;
    }

    private void publish(DateUtil.DateRange current) {
        ListFetchingUpdate update = new ListFetchingUpdate();
        update.setMessage(DateUtil.formatDate(current.start) + " - " + DateUtil.formatDate(current.end));
        this.publish(update);
    }

    private void addSendings(ReceiptIndex newIndex) {
        for (ReceiptEntry current : newIndex.getEntryList()) {
            if (!current.getCustomsReferenceNumber().isInitialized()) continue;
            this.sendings.put(current.getKey(), current);
        }
    }

    @Override
    protected void process(List<ListFetchingUpdate> chunks) {
        if (this.isCancelled()) {
            return;
        }
        for (ListFetchingUpdate update : chunks) {
            this.receiptPm.handle(update);
        }
    }
}

