/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvimport.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptImportHandle;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptPm;
import ch.transsoft.edec.util.Check;
import java.util.List;
import javax.swing.SwingWorker;

public class ReceiptFetcher
extends SwingWorker<Void, ReceiptFetchingUpdate> {
    private final ReceiptPm receiptPm;
    private final List<ReceiptImportHandle> handles;

    public ReceiptFetcher(ReceiptPm receiptPm, List<ReceiptImportHandle> handles) {
        this.receiptPm = receiptPm;
        this.handles = handles;
    }

    @Override
    protected void done() {
        this.receiptPm.finishFetchingEvv();
        if (this.isCancelled()) {
            return;
        }
        try {
            this.get();
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    @Override
    protected void process(List<ReceiptFetchingUpdate> chunks) {
        if (this.isCancelled()) {
            return;
        }
        for (ReceiptFetchingUpdate update : chunks) {
            this.receiptPm.handle(update);
        }
    }

    @Override
    protected Void doInBackground() {
        for (ReceiptImportHandle handle : this.handles) {
            if (this.isCancelled()) {
                return null;
            }
            this.createSending(handle);
        }
        return null;
    }

    private void createSending(ReceiptImportHandle handle) {
        EvvResponse evv = this.fetchReceipt(handle);
        if (evv == null) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        ReceiptFetchingUpdate result = new ReceiptFetchingUpdate();
        result.setEntry(handle.getEntry());
        result.setResponse(evv);
        result.setReceiptDocumentType(handle.getReceiptDocumentType());
        result.setAccount(handle.getAccount());
        this.publish(result);
    }

    private EvvResponse fetchReceipt(ReceiptImportHandle handle) {
        this.message(Services.getText(4709) + " " + handle.getCustomsDeclarationNumber());
        try {
            return Services.get(IEZVService.class).getEvv(this.receiptPm.getMode(), this.receiptPm.getImportID(), handle.getCustomsDeclarationNumber(), handle.getCustomsDeclarationVersion(), handle.getReceiptDocumentType());
        }
        catch (Exception e2) {
            new FetchEvvJobErrorHandler(false).handleError(e2);
            this.cancel(false);
            return null;
        }
    }

    private void message(String string) {
        ReceiptFetchingUpdate update = new ReceiptFetchingUpdate();
        update.setMessage(string);
        this.publish(update);
    }
}

