/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvimport.pm;

import ch.e_dec.xml.schema.edecreceiptresponse.v3.DocumentInformationType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestResponse;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.math.BigInteger;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class ReceiptFetchingUpdate {
    private String message;
    private ReceiptEntry entry;
    private EvvResponse response;
    private ReceiptDocumentType receiptDocumentType;
    private String account;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResponse(EvvResponse response) {
        Check.assertNotNull(response);
        this.response = response;
    }

    public void setReceiptDocumentType(ReceiptDocumentType receiptDocumentType) {
        Check.assertNotNull((Object)receiptDocumentType);
        this.receiptDocumentType = receiptDocumentType;
    }

    public ReceiptEntry getEntry() {
        return this.entry;
    }

    public void setEntry(ReceiptEntry receiptEntry) {
        this.entry = receiptEntry;
    }

    public EvvResponse getResponse() {
        return this.response;
    }

    public ReceiptDocumentType getReceiptDocumentType() {
        return this.receiptDocumentType;
    }

    public XMLGregorianCalendar getDocumentCreationDate() {
        return this.getDocumentInformation().getDocumentDate();
    }

    public String getDocumentDate() {
        return DateUtil.toEdecDateString(this.getDocumentCreationDate());
    }

    public String getCustomsDeclarationNumber() {
        return this.getDocumentInformation().getDocumentNumber();
    }

    @Nullable
    public String getBordereauNumber() {
        ReceiptRequestResponse receiptResponse = this.response.getResponse();
        if (receiptResponse.getTaxationDecisionVAT() != null) {
            return ReceiptFetchingUpdate.valueOf(receiptResponse.getTaxationDecisionVAT().getBordereauNumber());
        }
        if (receiptResponse.getTaxationDecisionCustomsDuties() != null) {
            return ReceiptFetchingUpdate.valueOf(receiptResponse.getTaxationDecisionCustomsDuties().getBordereauNumber());
        }
        if (receiptResponse.getRefundVAT() != null) {
            return ReceiptFetchingUpdate.valueOf(receiptResponse.getRefundVAT().getBordereauNumber());
        }
        if (receiptResponse.getRefundCustomsDuties() != null) {
            return ReceiptFetchingUpdate.valueOf(receiptResponse.getRefundCustomsDuties().getBordereauNumber());
        }
        throw Check.fail("No data found");
    }

    public ImportSendingKey getKey() {
        return new ImportSendingKey(this.getCustomsDeclarationNumber(), this.getDocumentDate());
    }

    private static String valueOf(BigInteger value) {
        return value == null ? null : value.toString();
    }

    private DocumentInformationType getDocumentInformation() {
        ReceiptRequestResponse receiptRequestResponse = this.response.getResponse();
        if (receiptRequestResponse.getRefundVAT() != null) {
            return receiptRequestResponse.getRefundVAT().getDocumentInformation();
        }
        if (receiptRequestResponse.getRefundCustomsDuties() != null) {
            return receiptRequestResponse.getRefundCustomsDuties().getDocumentInformation();
        }
        if (receiptRequestResponse.getTaxationDecisionVAT() != null) {
            return receiptRequestResponse.getTaxationDecisionVAT().getDocumentInformation();
        }
        if (receiptRequestResponse.getTaxationDecisionCustomsDuties() != null) {
            return receiptRequestResponse.getTaxationDecisionCustomsDuties().getDocumentInformation();
        }
        if (receiptRequestResponse.getTaxationDecisionExport() != null) {
            return receiptRequestResponse.getTaxationDecisionExport().getDocumentInformation();
        }
        throw Check.fail("No data found");
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }
}

