/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.evv.evvimport.pm;

import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.AddReceiptJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ListFetcher;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ListFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptFetcher;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptFetchingUpdate;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptImportHandle;
import ch.transsoft.edec.ui.dialog.evv.evvimport.pm.ReceiptListPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.DateUtil;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ReceiptPm
implements IPm {
    private final ReceiptListPm listPm;
    private final JDateChooser from;
    private final JDateChooser to;
    private final JComboBox<String> zazAccount;
    private final JButton fetchingListButton;
    private final JButton createSendingsButton;
    private final JLabel statusLabel;
    private final Component progressBar;
    private final OperatingMode mode;
    private final String importID;
    private volatile ListFetcher listFetchWorker;
    private volatile ReceiptFetcher evvFetchWorker;
    private final Map<ImportSendingKey, ReceiptEntry> createdImportSendings = new HashMap<ImportSendingKey, ReceiptEntry>();

    public ReceiptPm(OperatingMode mode, String importID) {
        this.mode = mode;
        this.importID = importID;
        this.listPm = new ReceiptListPm();
        this.from = new JDateChooser();
        this.to = new JDateChooser();
        List<String> accountNumbers = Services.get(IConfigService.class).getAccountNumbers();
        this.zazAccount = new JComboBox<String>(accountNumbers.toArray(new String[accountNumbers.size()]));
        this.fetchingListButton = new JButton(Services.getText(4906));
        this.createSendingsButton = new JButton(Services.getText(4907));
        this.progressBar = this.createProgressBar();
        this.statusLabel = new JLabel();
        this.hideStatusInfo();
        this.addButtonListeners();
    }

    private void addButtonListeners() {
        this.fetchingListButton.addActionListener(e2 -> {
            if (this.listFetchWorker != null) {
                this.listFetchWorker.cancel(true);
                return;
            }
            this.fetchList();
        });
        this.createSendingsButton.addActionListener(e2 -> {
            if (this.evvFetchWorker != null) {
                this.evvFetchWorker.cancel(true);
                return;
            }
            this.fetchEvv();
        });
    }

    private void fetchEvv() {
        this.startFetchingEvv();
        ArrayList<ReceiptImportHandle> handles = new ArrayList<ReceiptImportHandle>(this.getListPm().getList());
        this.evvFetchWorker = new ReceiptFetcher(this, handles);
        this.evvFetchWorker.execute();
    }

    private void fetchList() {
        if (!this.rangeValid() || !this.zazAccountValidate()) {
            DialogUtil.showWarningDialog(Services.getText(4706), Services.getText(4707));
            return;
        }
        this.listPm.clear();
        this.startFetchingList();
        this.listFetchWorker = new ListFetcher(this);
        this.setStatusInfo(Services.getText(865));
        this.listFetchWorker.execute();
    }

    private boolean zazAccountValidate() {
        String account = this.getSelectedZazAccount();
        return account != null && !account.isEmpty();
    }

    private boolean rangeValid() {
        if (this.getFromDate() == null) {
            return false;
        }
        if (this.getToDate() == null) {
            return false;
        }
        return this.getFromDate().compareTo(this.getToDate()) <= 0;
    }

    public Date getFromDate() {
        if (this.from.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.from.getDate());
    }

    public Date getToDate() {
        if (this.to.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.to.getDate());
    }

    public String getSelectedZazAccount() {
        return (String)this.zazAccount.getSelectedItem();
    }

    public Component getFrom() {
        return this.from;
    }

    public Component getTo() {
        return this.to;
    }

    public Component getZazAccount() {
        return this.zazAccount;
    }

    public Component getFetchingListButton() {
        return this.fetchingListButton;
    }

    public Component getCreateSendingsButton() {
        return this.createSendingsButton;
    }

    public ReceiptListPm getListPm() {
        return this.listPm;
    }

    public OperatingMode getMode() {
        return this.mode;
    }

    private JProgressBar createProgressBar() {
        JProgressBar result = new JProgressBar();
        result.setIndeterminate(true);
        return result;
    }

    public void hideStatusInfo() {
        this.statusLabel.setVisible(false);
        this.progressBar.setVisible(false);
    }

    public void setStatusInfo(String text) {
        this.statusLabel.setText("<html>" + text + "</html>");
        this.statusLabel.setVisible(true);
        this.progressBar.setVisible(true);
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public Component getProgressBar() {
        return this.progressBar;
    }

    public void finishFetchingEvv() {
        this.evvFetchWorker = null;
        this.createSendingsButton.setText(Services.getText(4907));
        this.fetchingListButton.setEnabled(true);
        this.hideStatusInfo();
    }

    private void startFetchingEvv() {
        this.fetchingListButton.setEnabled(false);
        this.createSendingsButton.setText(Services.getText(208));
    }

    public void finishFetchingList() {
        this.listFetchWorker = null;
        this.fetchingListButton.setText(Services.getText(4906));
        this.createSendingsButton.setEnabled(true);
        this.hideStatusInfo();
    }

    private void startFetchingList() {
        this.fetchingListButton.setText(Services.getText(208));
        this.createSendingsButton.setEnabled(false);
    }

    public void handle(ReceiptFetchingUpdate update) {
        if (update.getMessage() != null) {
            this.setStatusInfo(update.getMessage());
        }
        if (update.getResponse() != null) {
            this.addReceipt(update);
        }
    }

    private void addReceipt(ReceiptFetchingUpdate update) {
        if (update.getEntry() == null) {
            update.setEntry(this.getEntryFromNewSending(update));
        }
        Services.get(IBackendService.class).put(new AddReceiptJob(update, this), true);
        this.listPm.updateSendingCreated(update.getCustomsDeclarationNumber());
    }

    private synchronized ReceiptEntry getEntryFromNewSending(ReceiptFetchingUpdate update) {
        return this.createdImportSendings.get(update.getKey());
    }

    public synchronized void reportNewlyCreatedImportSending(ReceiptEntry entry) {
        this.createdImportSendings.put(entry.getKey(), entry);
    }

    public void handle(ListFetchingUpdate update) {
        if (update.getMessage() != null) {
            this.setStatusInfo(update.getMessage());
        }
        if (update.getEvvHandles() != null) {
            this.addEntries(update.getEvvHandles());
        }
    }

    private void addEntries(List<ReceiptImportHandle> receiptImportHandles) {
        for (ReceiptImportHandle current : receiptImportHandles) {
            this.listPm.addEntry(current);
        }
    }

    public String getImportID() {
        return this.importID;
    }
}

