/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvexport.pm;

import ch.transsoft.edec.model.config.conf.extract.IColInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.export.IColDesc;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.XMLUtil;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.w3c.dom.Node;

public class ExpColDesc
implements IColDesc {
    private int id;
    private int categoryId;
    private String path;
    private DescCategory category;
    private boolean enabled;
    private XPathExpression expression;
    private final int label;

    public static ExpColDesc createGlobal(int id, int label, int categoryId, String path, boolean defaultEnablement, IColInfo colInfo) {
        return new ExpColDesc(id, label, categoryId, DescCategory.global, path, colInfo.isEnabled(id, defaultEnablement));
    }

    public static ExpColDesc createHeader(int id, int label, int categoryId, String path, boolean defaultEnablement, IColInfo colInfo) {
        return new ExpColDesc(id, label, categoryId, DescCategory.header, path, colInfo.isEnabled(id, defaultEnablement));
    }

    public static ExpColDesc createItem(int id, int label, int categoryId, DescCategory category, String path, boolean defaultEnablement, IColInfo colInfo) {
        return new ExpColDesc(id, label, categoryId, category, path, colInfo.isEnabled(id, defaultEnablement));
    }

    private ExpColDesc(int id, int label, int categoryId, DescCategory category, String path, boolean enabled) {
        this.id = id;
        this.label = label;
        this.categoryId = categoryId;
        this.path = path;
        this.category = category;
        this.enabled = enabled;
        this.expression = XMLUtil.createExpression(path);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCategoryText() {
        if (this.categoryId == 0) {
            return null;
        }
        return Services.getText(this.categoryId);
    }

    public DescCategory getCategory() {
        return this.category;
    }

    @Override
    public String getId() {
        return Integer.toString(this.id);
    }

    public String getCaption() {
        if (this.label == 0) {
            String[] segs = this.path.split("/");
            return segs[segs.length - 1];
        }
        return Services.getText(this.label);
    }

    public String getPath() {
        return this.path;
    }

    public Object getValueAt(int columnIndex, int cellIndex) {
        switch (columnIndex) {
            case 0: {
                return this.isEnabled() ? ExpColDesc.getColLetters(cellIndex + 1) : "";
            }
            case 1: {
                return this.getCategoryText();
            }
            case 2: {
                return this.getCaption();
            }
            case 3: {
                return this.isEnabled();
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static String getColLetters(int cellIndex) {
        StringBuilder result = new StringBuilder();
        int steps = cellIndex > 26 ? (int)(Math.log(cellIndex) / Math.log(26.0)) : 0;
        int base = (int)Math.pow(26.0, steps);
        return ExpColDesc.appendColLetter(base, cellIndex, result).toString();
    }

    public static StringBuilder appendColLetter(int base, int remaining, StringBuilder result) {
        if (remaining < 27) {
            result.append((char)(64 + remaining));
            return result;
        }
        int current = (remaining - 1) / base;
        remaining -= current * base;
        result.append((char)(64 + current));
        return ExpColDesc.appendColLetter(base /= 26, remaining, result);
    }

    public void setEnabled(Object value) {
        this.enabled = (Boolean)value;
    }

    public static boolean isCellEditable(int columnIndex) {
        return columnIndex == 3;
    }

    public static String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Services.getText(4752);
            }
            case 1: {
                return Services.getText(4753);
            }
            case 2: {
                return Services.getText(4754);
            }
            case 3: {
                return Services.getText(4755);
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static int getColumnCount() {
        return 4;
    }

    public String getString(Node node) throws Exception {
        if (node == null) {
            return "";
        }
        return (String)this.expression.evaluate(node, XPathConstants.STRING);
    }

    public static enum DescCategory {
        global,
        header,
        common,
        vvm,
        vvz;

    }
}

