/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvexport.pm;

import ch.transsoft.edec.model.config.conf.extract.ExportExtractInfo;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evv.ExtractEvvExportJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.export.evvexport.pm.ExpColDesc;
import ch.transsoft.edec.ui.dialog.export.evvexport.pm.ExpColDescFactory;
import ch.transsoft.edec.ui.dialog.export.evvexport.pm.ExpDataExportList;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IBooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.FileChooserUtil;
import ch.transsoft.edec.util.FileUtil;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ExpDataExportPm
implements IPm {
    private final JDateChooser from = new JDateChooser();
    private final JDateChooser to = new JDateChooser();
    private final SelectionPm delimiterPm;
    private final BooleanPm showHeader;
    private final JLabel statusLabel;
    private final Component progressBar = this.createProgressBar();
    private final ExportExtractInfo config;
    private final ExpDataExportList headerDataListPm;
    private final ExpDataExportList itemDataListPm;
    private final List<ExpColDesc> items;
    private final List<ExpColDesc> headers;

    public ExpDataExportPm() {
        this.statusLabel = new JLabel();
        this.hideStatusInfo();
        this.config = Services.get(IConfigService.class).getExportExtractInfo();
        this.delimiterPm = new SelectionPm(this.config.getDelimiter());
        this.showHeader = new BooleanPm(this.config.getShowHeader());
        if (this.config.getFrom().isInitialized()) {
            this.from.setDate(this.config.getFrom().getValue());
        }
        if (this.config.getTo().isInitialized()) {
            this.to.setDate(this.config.getTo().getValue());
        }
        this.headers = ExpColDescFactory.getHeaderList(this.config.getColInfos());
        this.headerDataListPm = new ExpDataExportList(this.headers, null, this);
        this.items = ExpColDescFactory.getItemList(this.config.getColInfos());
        this.itemDataListPm = new ExpDataExportList(this.items, this.headerDataListPm, this);
    }

    public boolean export() {
        if (!this.rangeValid()) {
            DialogUtil.showWarningDialog(Services.getText(4706), Services.getText(4707));
            return false;
        }
        FileNode lastFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getExportDataExpFolder();
        File[] files = FileChooserUtil.chooseFiles(lastFolder.getValue(), Services.getText(5502), "evvExport.csv", Services.getText(5503));
        if (files == null) {
            return false;
        }
        if (files.length == 0) {
            return false;
        }
        lastFolder.setValue(files[0].getParentFile());
        Services.get(IConfigService.class).savePreferences();
        File file = FileUtil.addExtension(files[0], "csv");
        this.config.getFrom().setValue(this.getFromDate());
        this.config.getTo().setValue(this.getToDate());
        this.saveConfiguration();
        ExtractEvvExportJob job = new ExtractEvvExportJob(this.headers, this.items, this.getFromDate(), this.getToDate(), this.getDelimiterStr(), this.showHeader(), file);
        Services.get(IBackendService.class).put(job);
        return true;
    }

    private String getDelimiterStr() {
        return this.getDelimiter().getCurrentValue().getKey();
    }

    private boolean showHeader() {
        return this.getShowHeader().isSelected();
    }

    private boolean rangeValid() {
        if (this.getFromDate() == null) {
            return false;
        }
        if (this.getToDate() == null) {
            return false;
        }
        return this.getFromDate().compareTo(this.getToDate()) <= 0;
    }

    public Date getFromDate() {
        if (this.from.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.from.getDate());
    }

    public Date getToDate() {
        if (this.to.getDate() == null) {
            return null;
        }
        return DateUtil.getNormalizedDate(this.to.getDate());
    }

    public Component getFrom() {
        return this.from;
    }

    public Component getTo() {
        return this.to;
    }

    private JProgressBar createProgressBar() {
        JProgressBar result = new JProgressBar();
        result.setIndeterminate(true);
        return result;
    }

    public void hideStatusInfo() {
        this.statusLabel.setVisible(false);
        this.progressBar.setVisible(false);
    }

    public void setStatusInfo(String text) {
        this.statusLabel.setText("<html>" + text + "</html>");
        this.statusLabel.setVisible(true);
        this.progressBar.setVisible(true);
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public Component getProgressBar() {
        return this.progressBar;
    }

    public ExpDataExportList getHeaderPm() {
        return this.headerDataListPm;
    }

    public ExpDataExportList getItemPm() {
        return this.itemDataListPm;
    }

    public void saveConfiguration() {
        ArrayList<ExpColDesc> list = new ArrayList<ExpColDesc>();
        list.addAll(this.headerDataListPm.getList());
        list.addAll(this.itemDataListPm.getList());
        this.config.update(list);
        Services.get(IConfigService.class).saveExportExtractInfo(this.config);
    }

    public void updateUi() {
        this.headerDataListPm.fireColumnLetterChanged();
        this.itemDataListPm.fireColumnLetterChanged();
    }

    public SelectionPm getDelimiter() {
        return this.delimiterPm;
    }

    public IBooleanPm getShowHeader() {
        return this.showHeader;
    }
}

