/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.export.evvimport.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.IImportColDesc;
import ch.transsoft.edec.util.Check;

public abstract class AbstractColDesc
implements IImportColDesc {
    protected final int id;
    protected final int categoryId;
    protected DescCategory category;
    protected final int label;
    protected boolean enabled;

    public AbstractColDesc(int id, int categoryId, DescCategory category, boolean enabled, int label) {
        this.id = id;
        this.categoryId = categoryId;
        this.category = category;
        this.enabled = enabled;
        this.label = label;
    }

    public static String getColLetters(int cellIndex) {
        StringBuilder result = new StringBuilder();
        int steps = cellIndex > 26 ? (int)(Math.log(cellIndex) / Math.log(26.0)) : 0;
        int base = (int)Math.pow(26.0, steps);
        return AbstractColDesc.appendColLetter(base, cellIndex, result).toString();
    }

    public String getCategoryText() {
        if (this.categoryId == 0) {
            return null;
        }
        return Services.getText(this.categoryId);
    }

    @Override
    public Object getValueAt(int columnIndex, int cellIndex) {
        switch (columnIndex) {
            case 0: {
                return this.isEnabled() ? AbstractColDesc.getColLetters(cellIndex + 1) : "";
            }
            case 1: {
                return this.getCategoryText();
            }
            case 2: {
                return this.getCaption();
            }
            case 3: {
                return this.isEnabled();
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static StringBuilder appendColLetter(int base, int remaining, StringBuilder result) {
        if (remaining < 27) {
            result.append((char)(64 + remaining));
            return result;
        }
        int current = (remaining - 1) / base;
        remaining -= current * base;
        result.append((char)(64 + current));
        return AbstractColDesc.appendColLetter(base /= 26, remaining, result);
    }

    public static String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Services.getText(4752);
            }
            case 1: {
                return Services.getText(4753);
            }
            case 2: {
                return Services.getText(4754);
            }
            case 3: {
                return Services.getText(4755);
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    public static Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        throw Check.fail("invalid columnIndex: " + columnIndex);
    }

    @Override
    public void setEnabled(Object value) {
        this.enabled = (Boolean)value;
    }

    @Override
    public DescCategory getCategory() {
        return this.category;
    }

    public static enum DescCategory {
        header,
        common,
        vvm,
        vvz;

    }
}

