/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.insert;

import ch.transsoft.edec.model.config.pref.memento.ColumnMemento;
import ch.transsoft.edec.model.config.pref.memento.MasterdataDialogMemento;
import ch.transsoft.edec.model.config.pref.memento.MasterdataDialogMementos;
import ch.transsoft.edec.model.config.pref.memento.SortOrderMemento;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.masterdata.IDataFile;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.EscapeDialog;
import ch.transsoft.edec.ui.dialog.insert.IInsertDialogTrait;
import ch.transsoft.edec.ui.dialog.insert.ISelectionHandler;
import ch.transsoft.edec.ui.dialog.insert.InsertTableModel;
import ch.transsoft.edec.ui.gui.control.searchtable.SearchTable;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.decorator.SortOrder;

public class InsertDialog<T extends ListEntry<T>, D extends DataNode<D>>
extends EscapeDialog {
    private JTextField searchField;
    private IDisposable masterDataListener;
    private InsertTableModel<T> tableModel;
    private SearchTable table;
    private final ISelectionHandler<T> handler;
    private final IDataFile<D> dataFile;
    private final IInsertDialogTrait<D, T> trait;
    private final ITableAdapter[] tableAdapters;
    private boolean userSelectedRow = false;

    public InsertDialog(String title, JComponent source, IInsertDialogTrait<D, T> trait, IDataFile<D> dataFile, ITableAdapter[] tableAdapters, ISelectionHandler<T> handler) {
        super(title);
        this.trait = trait;
        this.dataFile = dataFile;
        this.tableAdapters = tableAdapters;
        this.handler = handler;
        this.setResizable(true);
        if (source != null) {
            Point pt = new Point();
            SwingUtilities.convertPointToScreen(pt, source);
            this.setBounds(pt.x + source.getSize().width + 10, pt.y, 600, 400);
        } else {
            DialogUtil.centerDialog(this, 600, 400);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.add(panel);
        panel.add(this.createSearchBar(), "North");
        panel.add(this.createTable(), "Center");
        this.applyMemento();
        this.addMasterDataListener();
        this.addSearchListener();
        this.searchField.requestFocusInWindow();
    }

    private void applyMemento() {
        MasterdataDialogMementos mementos = Services.get(IConfigService.class).getPreferences().getMasterdataDialogMementos();
        if (!mementos.hasMemento(this.dataFile)) {
            this.table.setSortOrder(0, SortOrder.ASCENDING);
            return;
        }
        MasterdataDialogMemento memento = mementos.getMasterdataDialogMemento(this.dataFile);
        this.setSize(memento.getWidth().getIntValue(), memento.getHeight().getIntValue());
        for (int i2 = 0; i2 < memento.getColumnMementos().size(); ++i2) {
            ColumnMemento columnMemento = memento.getColumnMementos().get(i2);
            SortOrder sortOrder = SortOrderMemento.valueOf(columnMemento.getSortOrder().getValue()).getSortOrder();
            if (sortOrder != SortOrder.UNSORTED) {
                this.table.setSortOrder(i2, sortOrder);
            }
            this.table.getColumnModel().getColumn(i2).setPreferredWidth(columnMemento.getColumnWidth().getIntValue());
        }
    }

    private void saveMemento() {
        MasterdataDialogMemento memento = Services.get(IConfigService.class).getPreferences().getMasterdataDialogMementos().getMasterdataDialogMemento(this.dataFile);
        memento.getWidth().setValue(Long.valueOf(this.getWidth()));
        memento.getHeight().setValue(Long.valueOf(this.getHeight()));
        ListNode<ColumnMemento> mementos = memento.getColumnMementos();
        mementos.clear();
        for (int i2 = 0; i2 < this.table.getColumnModel().getColumnCount(); ++i2) {
            TableColumn col = this.table.getColumnModel().getColumn(i2);
            int width = col.getWidth();
            SortOrder sortOrder = this.table.getSortOrder(i2);
            ColumnMemento columnMemento = NodeFactory.create(ColumnMemento.class);
            columnMemento.getColumnWidth().setValue(Long.valueOf(width));
            columnMemento.getSortOrder().setValue(sortOrder.toString());
            mementos.add(columnMemento);
        }
        Services.get(IConfigService.class).savePreferences();
    }

    private void addSearchListener() {
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                InsertDialog.this.table.searchTextChanged(InsertDialog.this.searchField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                InsertDialog.this.table.searchTextChanged(InsertDialog.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void keyReleased(KeyEvent e2) {
            }

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 38) {
                    InsertDialog.this.table.searchNext(true);
                } else if (e2.getKeyCode() == 40) {
                    InsertDialog.this.table.searchNext(false);
                } else if (e2.getKeyCode() == 10) {
                    InsertDialog.this.elementSelected();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyChar() != '\n') {
                    return;
                }
                InsertDialog.this.elementSelected();
                e2.consume();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() != 2) {
                    return;
                }
                InsertDialog.this.elementSelected();
            }
        });
    }

    private void elementSelected() {
        if (!this.table.hasSelectedRow()) {
            return;
        }
        this.dispose();
        this.handler.selected(this.tableModel.getRow(this.table.getSelectionIndex()));
        this.userSelectedRow = true;
    }

    private void addMasterDataListener() {
        this.masterDataListener = Services.get(IDataService.class).addDataListener(this.dataFile, data -> this.tableModel.setData(this.trait.getListEntries(data)));
    }

    @Override
    protected void handleDispose() {
        this.saveMemento();
        this.masterDataListener.dispose();
    }

    private Component createSearchBar() {
        JPanel result = new JPanel();
        result.setOpaque(true);
        result.setBackground(Color.WHITE);
        result.setLayout(new MigLayout());
        result.add(new Label(Services.getText(207)));
        this.searchField = new JTextField();
        result.add((Component)this.searchField, "width 200!");
        this.searchField.requestFocusInWindow();
        return result;
    }

    private Component createTable() {
        JPanel result = new JPanel();
        result.setOpaque(true);
        result.setBackground(Color.WHITE);
        result.setLayout(new BorderLayout());
        D data = Services.get(IDataService.class).getMasterData(this.dataFile);
        this.tableModel = new InsertTableModel<T>(this.trait.getListEntries(data), this.tableAdapters);
        this.table = new SearchTable(this.tableModel);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        result.add(scrollPane);
        return result;
    }

    public boolean userSelectedRow() {
        return this.userSelectedRow;
    }
}

