/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.pm;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseStateEnum;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.webservices.LicenseAlreadyBoughtException;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.ui.dialog.license.pm.LicenseDialogPm;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.ErrorUtil;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.openapitools.client.ApiException;

public class BuyEvvExportTabPm
implements IPm {
    private final Label flash = new Label();
    private final JCheckBox acceptAGBs = new JCheckBox();
    private final JButton buyButton = new JButton();
    private final Label label1 = new Label();
    private final Label label2 = new Label();
    private final LicenseDialogPm parentPm;
    private LicenseInfo licenseInfo;

    public BuyEvvExportTabPm(LicenseDialogPm parentPm) {
        this.parentPm = parentPm;
        this.acceptAGBs.setText(Services.getText(4179));
        this.buyButton.setText(Services.getText(4059));
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.addBuyButtonListener();
        this.updateState();
    }

    public void updateConfiguration() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.updateState();
    }

    private void updateState() {
        if (this.licenseInfo.getLicenseStateEvvExportValue() == LicenseStateEnum.LICENSED) {
            String text = "<html><h3>" + Services.getText(4060) + "</h3></html>";
            this.label1.setText(text);
            this.buyButton.setEnabled(false);
            this.acceptAGBs.setSelected(true);
            this.acceptAGBs.setEnabled(false);
            return;
        }
        if (this.licenseInfo.getLicenseStateEvvExportValue() == LicenseStateEnum.STUDENT) {
            String text = "<html><h3>" + Services.getText(4062) + "</h3></html>";
            this.label1.setText(text);
            this.buyButton.setEnabled(false);
            this.acceptAGBs.setSelected(true);
            this.acceptAGBs.setEnabled(false);
            return;
        }
        String text = "<html><h3>" + Services.format(4064, 4182) + "</h3></html>";
        this.label1.setText(text);
        this.buyButton.setEnabled(true);
        this.acceptAGBs.setSelected(false);
        this.acceptAGBs.setEnabled(true);
    }

    private void addBuyButtonListener() {
        this.buyButton.addActionListener(e2 -> this.buyEvvExportModule());
    }

    private void buyEvvExportModule() {
        if (!this.acceptAGBs.isSelected()) {
            this.flash.setBad("<html><b>" + Services.getText(4065) + "</b></html>");
            return;
        }
        this.flash.reset();
        this.flash.setGood("");
        if (!this.contactCrmServer(this.licenseInfo.getGuidValue())) {
            return;
        }
        this.licenseInfo.buyLicenseEvvExport();
        Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
        this.updateState();
        this.parentPm.updateState(4);
        String text = "<html><h3>" + Services.getText(4066) + "</h3>" + Services.getText(4067) + "</html>";
        this.label1.setGood(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contactCrmServer(String guid) {
        try {
            this.parentPm.setHourGlassCursor();
            CustomerManagementFacade.buyLicenseEvvExport(guid);
            boolean bl = true;
            return bl;
        }
        catch (LicenseAlreadyBoughtException e2) {
            this.flash.setBad(Services.getText(4068));
            boolean bl = true;
            return bl;
        }
        catch (UnknownGuidException e3) {
            this.flash.setBad(Services.getText(4069));
        }
        catch (Exception e4) {
            if (e4.getCause() instanceof ApiException) {
                ErrorUtil.handleConnectionError((ApiException)e4.getCause());
            } else {
                ErrorUtil.log(e4, Services.getText(4070));
            }
        }
        finally {
            this.parentPm.setNormalCursor();
        }
        return false;
    }

    public boolean isGreen() {
        return this.licenseInfo.getLicenseStateEvvExportValue() != LicenseStateEnum.DEMO;
    }

    public Component getFlash() {
        return this.flash;
    }

    public JCheckBox getAcceptAGBs() {
        return this.acceptAGBs;
    }

    public JButton getBuyButton() {
        return this.buyButton;
    }

    public Label getLabel1() {
        return this.label1;
    }

    public Label getLabel2() {
        return this.label2;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }
}

