/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.pm;

import ch.transsoft.edec.model.config.conf.license.CertificateInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.webservices.UnknownGuidException;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.ui.dialog.license.pm.LicenseDialogPm;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.Base64;
import ch.transsoft.edec.util.CertificateUtil;
import ch.transsoft.edec.util.ErrorUtil;
import ch.transsoft.edec.util.UidUtil;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openapitools.client.ApiException;

public class EzvTabPm
implements IPm {
    private final Label flash = new Label("", true);
    private final Label leftTitle = new Label("", true);
    private final Label rightTitle = new Label("", true);
    private final JTextField uid = new JTextField();
    private final JPasswordField certPassword = new JPasswordField();
    JCheckBox showPasswordCheckBox = new JCheckBox(Services.getText(4021));
    private final JTextField certName = new JTextField();
    private final JButton certChooseButton = new JButton("Import", IconLoader.getIcon("icon/license/Folder-small.png"));
    private final JButton certSaveButton = new JButton(Services.getText(201));
    private final LicenseDialogPm parentPm;
    private String certData = "";
    private LicenseInfo licenseInfo;

    public EzvTabPm(LicenseDialogPm licenseDialogPm) {
        this.parentPm = licenseDialogPm;
        this.certChooseButton.setToolTipText(Services.getText(4071));
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.addListeners();
        this.updateState();
        this.initFields();
    }

    private void addListeners() {
        this.certChooseButton.addActionListener(e2 -> this.chooseCertFile());
        this.certSaveButton.addActionListener(e2 -> this.saveCert());
        this.addShowPasswordCheckboxListener();
    }

    private void addShowPasswordCheckboxListener() {
        char defaultEchoChar = this.certPassword.getEchoChar();
        this.showPasswordCheckBox.addActionListener(e2 -> {
            JCheckBox checkBox = (JCheckBox)e2.getSource();
            if (checkBox.isSelected()) {
                this.certPassword.setEchoChar('\u0000');
            } else {
                this.certPassword.setEchoChar(defaultEchoChar);
            }
        });
    }

    public void updateConfiguration() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.updateState();
        this.initFields();
    }

    private void initFields() {
        CertificateInfo cert = this.licenseInfo.getCertificate();
        this.certPassword.setText(cert.getCertificatePassword().getValue());
        this.uid.setText(cert.getUid().getValue());
        this.certName.setText(cert.getCertFileName().getValue());
        this.certData = cert.getCertificateData().getValue();
        this.flash.setText("");
    }

    private void saveCert() {
        this.flash.reset();
        if (String.valueOf(this.certPassword.getPassword()).isEmpty()) {
            this.flash.setBad(Services.getText(4162));
            return;
        }
        if (this.uid.getText().isEmpty()) {
            this.flash.setBad(Services.getText(4163));
            return;
        }
        String uidValue = this.uid.getText().trim();
        if (!UidUtil.isValidUid(uidValue)) {
            this.flash.setBad(Services.getText(4165));
            return;
        }
        if (!CertificateUtil.isPasswordValid(this.certData, String.valueOf(this.certPassword.getPassword()))) {
            this.flash.setBad(Services.getText(4076));
            return;
        }
        if (this.certData.isEmpty()) {
            this.flash.setBad(Services.getText(4166));
            return;
        }
        CertificateInfo cert = this.licenseInfo.getCertificate();
        cert.getUid().setValue(uidValue);
        cert.getCertificatePassword().setValue(String.valueOf(this.certPassword.getPassword()));
        cert.getCertificateData().setValue(this.certData);
        cert.getCertFileName().setValue(this.certName.getText());
        Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
        this.parentPm.updateState(2);
        if (!this.contactCrmServer(this.licenseInfo.getGuidValue(), uidValue, String.valueOf(this.certPassword.getPassword()))) {
            return;
        }
        this.flash.setGood(Services.getText(4077));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contactCrmServer(String guid, String uid, String password) {
        try {
            this.parentPm.setHourGlassCursor();
            CustomerManagementFacade.setCustomsInformation(guid, uid, password);
            boolean bl = true;
            return bl;
        }
        catch (UnknownGuidException e2) {
            this.flash.setBad(Services.getText(4069));
        }
        catch (Exception e3) {
            if (e3.getCause() instanceof ApiException) {
                ErrorUtil.handleConnectionError((ApiException)e3.getCause());
            } else {
                ErrorUtil.log(e3, Services.getText(4078));
            }
        }
        finally {
            this.parentPm.setNormalCursor();
        }
        return false;
    }

    private void chooseCertFile() {
        this.flash.reset();
        JFrame frame = Services.get(IGuiService.class).getMainFrame();
        FileDialog dialog = new FileDialog((Frame)frame, Services.getText(4071), 0);
        dialog.setFile("*.p12");
        dialog.setVisible(true);
        String file = dialog.getFile();
        String path = dialog.getDirectory();
        if (path == null) {
            return;
        }
        if (file == null) {
            return;
        }
        this.certName.setText(file);
        File target = new File(path, file);
        try {
            this.certData = Base64.encodeFromFile(target.getPath());
        }
        catch (IOException e2) {
            this.flash.setBad(Services.getText(4079) + " " + e2.getMessage());
        }
    }

    private void updateState() {
        this.leftTitle.setText("<html><h3>" + Services.getText(4080) + "</h3></html>");
        this.rightTitle.setText("<html><h3>" + Services.getText(4081) + "</h3></html>");
        this.certName.setText(this.licenseInfo.getCertificate().getCertFileName().getValue());
    }

    public boolean isGreen() {
        return this.licenseInfo.getCertificate().isReady();
    }

    public Component getFlash() {
        return this.flash;
    }

    public Label getLeftTitle() {
        return this.leftTitle;
    }

    public Label getRightTitle() {
        return this.rightTitle;
    }

    public JTextField getUID() {
        return this.uid;
    }

    public JPasswordField getCertPassword() {
        return this.certPassword;
    }

    public JCheckBox getShowPasswordCheckbox() {
        return this.showPasswordCheckBox;
    }

    public JTextField getCertName() {
        return this.certName;
    }

    public String getCertData() {
        return this.certData;
    }

    public JButton getCertChooseButton() {
        return this.certChooseButton;
    }

    public JButton getCertSaveButton() {
        return this.certSaveButton;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public LicenseDialogPm getParentPm() {
        return this.parentPm;
    }
}

