/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.pm;

import ch.transsoft.edec.model.config.conf.license.LicenseInfo;
import ch.transsoft.edec.model.config.conf.license.LicenseStateEnum;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.demodata.DeployDemoData;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.dialog.license.pm.BuyEdecExportTabPm;
import ch.transsoft.edec.ui.dialog.license.pm.BuyEvvExportTabPm;
import ch.transsoft.edec.ui.dialog.license.pm.BuyEvvImportTabPm;
import ch.transsoft.edec.ui.dialog.license.pm.EzvTabPm;
import ch.transsoft.edec.ui.dialog.license.pm.RegisterTabPm;
import ch.transsoft.edec.ui.dialog.license.pm.RootFolderTabPm;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.JLabel;

public class LicenseDialogPm
implements IPm,
IDisposable {
    private final Label flash = new Label("flash", true);
    private LicenseInfo licenseInfo;
    private final ListenerList<LicenseDialogListener> listeners = new ListenerList();
    private final RootFolderTabPm rootFolderTabPm;
    private final RegisterTabPm registerTabPm;
    private final EzvTabPm ezvTabPm;
    private final BuyEdecExportTabPm buyEdecExportTabPm;
    private final BuyEvvExportTabPm buyEvvExportTabPm;
    private final BuyEvvImportTabPm buyEvvImportTabPm;
    private final JLabel testTitle = new JLabel();
    private IDisposable configListener;

    public LicenseDialogPm() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
        this.rootFolderTabPm = new RootFolderTabPm(this);
        this.registerTabPm = new RegisterTabPm(this);
        this.ezvTabPm = new EzvTabPm(this);
        this.buyEdecExportTabPm = new BuyEdecExportTabPm(this);
        this.buyEvvExportTabPm = new BuyEvvExportTabPm(this);
        this.buyEvvImportTabPm = new BuyEvvImportTabPm(this);
        this.internalUpdateState();
        this.addConfigListener();
    }

    void updateConfiguration() {
        this.licenseInfo = Services.get(IConfigService.class).getLicenseInfo();
    }

    public void saveLicenseInfo() {
        Services.get(IConfigService.class).saveLicenseInfo(this.licenseInfo);
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    private void addConfigListener() {
        this.configListener = Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                LicenseDialogPm.this.updateState(null);
                LicenseDialogPm.this.triggerUpdateConfiguration();
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void rootChanged() {
            }
        });
    }

    public RootFolderTabPm getRootFolderTabPm() {
        return this.rootFolderTabPm;
    }

    private void triggerStateChanged(Integer selection) {
        for (LicenseDialogListener listener : this.listeners) {
            listener.updateState(selection);
        }
    }

    private void triggerDispose() {
        for (LicenseDialogListener listener : this.listeners) {
            listener.dispose();
        }
    }

    private void triggerUpdateConfiguration() {
        for (LicenseDialogListener listener : this.listeners) {
            listener.updateConfiguration();
        }
    }

    public RegisterTabPm getRegisterTabPm() {
        return this.registerTabPm;
    }

    public EzvTabPm getEzvTabPm() {
        return this.ezvTabPm;
    }

    public BuyEdecExportTabPm getBuyEdecExportTabPm() {
        return this.buyEdecExportTabPm;
    }

    public BuyEvvExportTabPm getBuyEvvExportTabPm() {
        return this.buyEvvExportTabPm;
    }

    public BuyEvvImportTabPm getBuyEvvImportTabPm() {
        return this.buyEvvImportTabPm;
    }

    public JLabel getTestTitle() {
        return this.testTitle;
    }

    public void add(LicenseDialogListener listener) {
        this.listeners.add(listener);
    }

    public void updateState(Integer selection) {
        this.internalUpdateState();
        this.triggerStateChanged(selection);
    }

    private void internalUpdateState() {
        if (this.atLeastOneModuleIs(LicenseStateEnum.LICENSED)) {
            this.testTitle.setText("<html><h2>ExpoVit<sup>\u00ae</sup><i>e-dec</i> " + Services.getText(4083) + "</h2></html>");
        } else if (this.atLeastOneModuleIs(LicenseStateEnum.CLOSED)) {
            this.testTitle.setText("<html><h2>ExpoVit<sup>\u00ae</sup><i>e-dec</i> " + Services.getText(4085) + "</h2></html>");
        } else if (this.atLeastOneModuleIs(LicenseStateEnum.STUDENT)) {
            this.testTitle.setText("<html><h2>ExpoVit<sup>\u00ae</sup><i>e-dec</i> " + Services.getText(4084) + "</h2></html>");
        } else if (this.getEzvTabPm().isGreen()) {
            this.testTitle.setText("<html><h2>" + Services.getText(4086) + "</h2></html>");
        }
    }

    private boolean atLeastOneModuleIs(LicenseStateEnum state) {
        return this.licenseInfo.getLicenseStateEdecExportValue() == state || this.licenseInfo.getLicenseStateEvvExportValue() == state || this.licenseInfo.getLicenseStateEvvImportValue() == state;
    }

    public void rootChanged() {
        this.triggerUpdateConfiguration();
    }

    public void deployDemoData() {
        if (Services.get(IConfigService.class).hasLicense()) {
            return;
        }
        Services.get(IBackendService.class).put(new DeployDemoData());
    }

    public void setHourGlassCursor() {
        Services.get(IGuiService.class).setHourGlassCursor(true);
    }

    public void setNormalCursor() {
        Services.get(IGuiService.class).setHourGlassCursor(false);
    }

    @Override
    public void dispose() {
        this.configListener.dispose();
    }

    public Label getFlash() {
        return this.flash;
    }

    public static interface LicenseDialogListener {
        public void updateConfiguration();

        public void updateState(Integer var1);

        public void dispose();
    }
}

