/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.license.pm;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.future.passar.PassarFutureService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.license.pm.LicenseDialogPm;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileChooserUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.GuiUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class RootFolderTabPm
implements IPm {
    private final JTextField currentRootPath;
    private final Label flash = new Label("", true);
    private boolean isGreen;
    private final LicenseDialogPm parentPm;
    private final IConfigService configService = Services.get(IConfigService.class);
    private final JButton folderChooser;

    public RootFolderTabPm(LicenseDialogPm parentPm) {
        this.parentPm = parentPm;
        this.currentRootPath = new JTextField();
        this.currentRootPath.setEditable(false);
        this.folderChooser = new JButton(Services.getText(4119));
        this.folderChooser.setToolTipText(Services.getText(4090));
        this.addFolderChooserListener();
        this.isGreen = false;
        if (!this.configService.hasRootFolder()) {
            return;
        }
        File dir = this.configService.getRootFolder();
        if (!dir.exists()) {
            this.flash.setBad("<html><b>" + String.format(Services.getText(4093), dir) + "</b></html>");
            return;
        }
        this.currentRootPath.setText(dir.getPath());
        this.isGreen = true;
    }

    public void openExplorer() {
        File path = this.configService.getRootFolder();
        if (!path.exists()) {
            path = new File(this.configService.getDefaultRootDir().getPath());
        }
        DocumentUtil.openDirectory(path);
    }

    private void addFolderChooserListener() {
        this.folderChooser.addActionListener(this::openFolderDialog);
    }

    private void openFolderDialog(ActionEvent e2) {
        File dir;
        File selection;
        if (!this.configService.hasRootFolder()) {
            JOptionPane.showMessageDialog(GuiUtil.getWindowAncestor(e2), Services.getText(4092), Services.getText(4091), 1);
        }
        if ((selection = FileChooserUtil.chooseFolder(dir = this.configService.getRootFolder(), Services.getText(4094), Services.getText(212))) == null) {
            return;
        }
        this.saveRootPath(selection, GuiUtil.getWindowAncestor(e2));
    }

    private void saveRootPath(File newRootFile, Window windowAncestor) {
        if (Services.get(IBackendService.class).isProcessing()) {
            return;
        }
        this.flash.setGood("");
        Services.get(IAppService.class).closeCurrentSending();
        newRootFile.mkdirs();
        if (newRootFile.getPath().trim().isEmpty()) {
            this.flash.setBad(Services.getText(4095));
        } else if (this.configService.getRootFolder().getPath().equals(newRootFile.getPath().trim())) {
            this.flash.setBad(Services.getText(4096));
        } else if (!newRootFile.exists()) {
            this.flash.setBad(Services.getText(4097) + " " + String.valueOf(newRootFile));
        } else if (!this.hasReadAccess(newRootFile)) {
            String user = Services.get(IConfigService.class).getUserName();
            this.flash.setBad(String.format(Services.getText(4098), user, newRootFile));
        } else if (PassarFutureService.isPassarRoot(newRootFile)) {
            this.flash.setBad(Services.getText(4121));
        } else {
            boolean copyData = false;
            if (this.configService.hasRootFolder() && !this.isExpoVitFolder(newRootFile) && !this.newFolderIsChildOfCurrent(newRootFile)) {
                DialogUtil.Answer result = this.transferConfiguration(newRootFile.getPath(), windowAncestor);
                if (result == DialogUtil.Answer.cancel) {
                    return;
                }
                copyData = result == DialogUtil.Answer.yes;
            }
            this.configService.changeRootFolder(newRootFile, copyData);
            this.isGreen = true;
            this.flash.setGood(Services.getText(4099));
            this.currentRootPath.setText(newRootFile.getPath());
            this.parentPm.rootChanged();
            this.parentPm.updateState(null);
        }
    }

    private boolean newFolderIsChildOfCurrent(File newRootPath) {
        return FileUtil.isChildSave(this.configService.getRootFolder(), newRootPath);
    }

    private boolean isExpoVitFolder(File dir) {
        if (dir.list() == null) {
            return false;
        }
        for (String child : dir.list()) {
            File file = new File(dir, child);
            if (!file.isDirectory() || !file.getName().equals("masterdata")) continue;
            return true;
        }
        return false;
    }

    private DialogUtil.Answer transferConfiguration(String newLocation, Window windowAncestor) {
        String message = Services.getText(4102) + "\n\n" + Services.getText(4103) + " " + String.valueOf(this.configService.getRootFolder()) + "\n" + Services.getText(4104) + " " + newLocation + "\n\n";
        return DialogUtil.showDialog(windowAncestor, 3, Services.getText(4101), message, Services.getText(215), Services.getText(216), Services.getText(208));
    }

    private boolean hasReadAccess(File dir) {
        File testFile = new File(dir, "testFile");
        try {
            new FileOutputStream(testFile).close();
        }
        catch (Exception e2) {
            return false;
        }
        if (!testFile.exists()) {
            return false;
        }
        return testFile.delete();
    }

    public boolean isGreen() {
        return this.isGreen;
    }

    public JTextField getCurrentRootPathField() {
        return this.currentRootPath;
    }

    public Label getFlash() {
        return this.flash;
    }

    public LicenseDialogPm getParentPm() {
        return this.parentPm;
    }

    public IConfigService getConfigService() {
        return this.configService;
    }

    public JButton getFolderChooser() {
        return this.folderChooser;
    }
}

