/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.ui.dialog.mail.gui.FileTransferHandler;
import ch.transsoft.edec.ui.dialog.mail.gui.OpenHandleRenderer;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.OpenHandle;
import ch.transsoft.edec.ui.dialog.mail.pm.IMailDialogPm;
import ch.transsoft.edec.ui.gui.control.DefaultPanel;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.table.Table;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;

public class MailPanel
extends DefaultPanel {
    public MailPanel(IMailDialogPm pm) {
        this.setLayout(new MigLayout("", "[right, 170::][grow]50", "10[]10[][]20[][][grow]20[20][grow]"));
        this.add(new Label("<html>" + Services.getText(4202) + "</html>"));
        this.add((Component)pm.getToAddressField(), "width 300::, split");
        if (pm.getAddButton() != null) {
            this.add((Component)pm.getAddButton(), "width 20!, height 20!");
        }
        this.add((Component)new Label("<html>" + Services.getText(4203) + "</html>"), "wrap");
        if (pm.isSendViaOutlook()) {
            this.add((Component)new JLabel(), "wrap");
            this.add((Component)new JLabel(), "wrap");
        } else if (pm.isSendViaTransSoftServer()) {
            this.add(new Label("<html>" + Services.getText(4204) + "</html>"));
            this.add((Component)pm.getFromAddressField(), "width 300:: , wrap");
            this.add((Component)pm.getSendCopy(), "skip, wrap");
        } else if (pm.isSendViaSMTP()) {
            this.add(new Label("<html>" + Services.getText(4204) + "</html>"));
            this.add((Component)pm.getFromAddressField(), "width 300:: , wrap");
            pm.getFromAddressField().setEnabled(false);
            this.add((Component)pm.getSendCopy(), "skip, wrap");
        } else {
            throw new IllegalStateException("Unexpected E-Mail Send type");
        }
        this.add(this.createTextSelectionPanel(pm), "skip, wrap");
        this.add((Component)new Label(Services.getText(4245)), "top");
        this.add((Component)pm.getSubject(), "grow, wrap");
        this.add((Component)new Label(Services.getText(4205)), "top");
        this.add((Component)pm.getContent(), "grow, wrap, height 150:400:");
        this.add((Component)new Label(Services.getText(4206)), "skip, wrap");
        this.add((Component)new Label(Services.getText(4207)), "top");
        Table<AttachmentEntry> table = new Table<AttachmentEntry>(pm.getAttachmentModel(), 120, AttachmentEntry.tableConfig);
        this.add(table, "grow, height 150::");
        table.setTransferHandler(new FileTransferHandler(pm.getAttachmentModel()));
        table.setDefaultRenderer(OpenHandle.class, new OpenHandleRenderer());
    }

    private Component createTextSelectionPanel(IMailDialogPm pm) {
        DefaultPanel result = new DefaultPanel();
        result.setLayout(new MigLayout("", "0[]20[]", ""));
        result.add(pm.getTextSelectionCombo(), "width :300:450");
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.add(pm.getNewAction());
        bar.add(pm.getSaveAction());
        bar.add(pm.getDeleteAction());
        result.add(bar);
        return result;
    }
}

