/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.model;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import javax.swing.ImageIcon;

public class EvvAttachment
implements IAttachmentBody {
    private File file;
    private final String filename;

    public EvvAttachment(File file, String filename) {
        this.file = file;
        this.filename = filename;
    }

    @Override
    public byte[] getData(Object context) throws Exception {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfWriter.createReceipt(this.file, (OutputStream)bos);
            return bos.toByteArray();
        }
        catch (Exception e2) {
            throw Check.fail(e2, Services.getText(4211));
        }
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getMimeType() {
        return "application/pdf";
    }

    @Override
    public boolean supportPreview() {
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/pdf-small.png");
    }

    @Override
    public void showDocument() {
        try {
            Services.get(IGuiService.class).setHourGlassCursor(true);
            DocumentUtil.showPdf(this.getData(null), "evv");
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(4210));
        }
        finally {
            Services.get(IGuiService.class).setHourGlassCursor(false);
        }
    }

    @Override
    public void copyToFolder(File folder) {
    }
}

