/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.model;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileUtil;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class FileSystemAttachment
implements IAttachmentBody {
    private final File file;
    private final String filename;
    private final boolean fileFromSendingFolder;

    public FileSystemAttachment(File file, String filename, boolean fileFromSendingFolder) {
        Check.assertNotNull(file);
        this.fileFromSendingFolder = fileFromSendingFolder;
        this.filename = filename;
        this.file = file;
    }

    @Override
    public String getFileName() {
        if (this.filename != null) {
            return this.filename;
        }
        return this.file.getName();
    }

    @Override
    public byte[] getData(Object context) throws IOException {
        return FileUtil.getFileAsByteArray(this.file);
    }

    @Override
    public String getMimeType() {
        return "application/file";
    }

    @Override
    public boolean supportPreview() {
        return true;
    }

    @Override
    public Icon getIcon() {
        Icon result;
        FileSystemView view = FileSystemView.getFileSystemView();
        if (view == null) {
            return this.getDefaultIcon();
        }
        try {
            result = view.getSystemIcon(this.file);
        }
        catch (Exception e2) {
            return this.getDefaultIcon();
        }
        if (result == null) {
            return this.getDefaultIcon();
        }
        return result;
    }

    private Icon getDefaultIcon() {
        return IconLoader.getIcon("icon/New-small.png");
    }

    @Override
    public void showDocument() {
        DocumentUtil.showDoc(this.file);
    }

    @Override
    public void copyToFolder(File folder) {
        File target = new File(folder, this.file.getName());
        if (this.fileFromSendingFolder) {
            return;
        }
        try {
            FileUtil.copyFile(this.file, target);
        }
        catch (IOException e2) {
            Services.get(ILoggingService.class).logAndReport(e2, "Failed to save " + String.valueOf(this.file) + " in folder " + String.valueOf(target));
        }
    }
}

