/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.pm;

import ch.e_dec.xml.schema.edec.v4.GoodsDeclarations;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.XMLWriter;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.CustomerDeclarationNumberWithVersion;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.ezv.aza.AzaTranslator;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormService;
import ch.transsoft.edec.service.validate.IValidateService;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.EvvAttachment;
import ch.transsoft.edec.ui.dialog.mail.model.FileSystemAttachment;
import ch.transsoft.edec.ui.dialog.mail.model.FormAttachment;
import ch.transsoft.edec.ui.dialog.mail.model.JaxbAttachment;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;

public class AttachmentFactory {
    public static final String EDEC_FILE = "e-dec_xml.txt";
    public static final String SENDING_FILE = "sending.xml";
    private final boolean addPrefixToFilename;

    public AttachmentFactory(boolean addPrefixToFilename) {
        this.addPrefixToFilename = addPrefixToFilename;
    }

    public void addForms(Sending sending, ListNode<AttachmentEntry> result) {
        for (IFormDesc form : this.getForms()) {
            if (!sending.getForms().isSelected(form)) continue;
            this.addForm(sending, form, result);
        }
    }

    private void addForm(Sending sending, IFormDesc form, ListNode<AttachmentEntry> result) {
        AttachmentEntry entry = NodeFactory.create(AttachmentEntry.class);
        String filename = this.getFullFileName(sending, form.getName(sending) + ".pdf");
        entry.getAttachmentHandle().setBody(new FormAttachment(sending, form, filename));
        result.add(entry);
    }

    private List<IFormDesc> getForms() {
        return Services.get(IFormService.class).getForms();
    }

    public boolean addEdec(Sending sending, ListNode<AttachmentEntry> result) {
        if (!Services.get(IValidateService.class).validate(false)) {
            return false;
        }
        byte[] data = this.getEdecXmlBytes(sending);
        AttachmentEntry entry = NodeFactory.create(AttachmentEntry.class);
        entry.getAttachmentHandle().setBody(new JaxbAttachment(data, this.getFullFileName(sending, EDEC_FILE)));
        result.add(entry);
        return true;
    }

    private byte[] getEdecXmlBytes(Sending sending) {
        GoodsDeclarations data = new AzaTranslator(sending).createGoodsDeclaration();
        try {
            return DocumentUtil.marshall(GoodsDeclarations.class, data);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public void addSendingXml(Sending sending, ListNode<AttachmentEntry> result) {
        XMLWriter writer = new XMLWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer.write(out, sending);
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
        AttachmentEntry entry = NodeFactory.create(AttachmentEntry.class);
        entry.getAttachmentHandle().setBody(new JaxbAttachment(out.toByteArray(), this.getFullFileName(sending, SENDING_FILE)));
        result.add(entry);
    }

    private String getFullFileName(Sending sending, String lastNamePart) {
        if (!this.addPrefixToFilename) {
            return lastNamePart;
        }
        CustomerDeclarationNumberWithVersion prefix = sending.getGoodsDeclaration().getCustomsDeclarationNumberWithVersion();
        if (prefix.getValue().isEmpty()) {
            return lastNamePart;
        }
        return String.valueOf(prefix) + " " + lastNamePart;
    }

    public void addAl(Sending sending, ListNode<AttachmentEntry> result) {
        if (!sending.getState().hasAl()) {
            return;
        }
        File al = SendingUtil.getAlPath(sending.getSendingId(), true);
        AttachmentEntry entry = NodeFactory.create(AttachmentEntry.class);
        entry.getAttachmentHandle().setBody(new FileSystemAttachment(al, this.getFullFileName(sending, Services.getText(4212) + ".pdf"), true));
        result.add(entry);
    }

    public void addEvv(Sending sending, Label flash, ListNode<AttachmentEntry> result) {
        File signatureCheckPath;
        if (!sending.getState().hasEvv()) {
            flash.setBad(Services.getText(633));
            return;
        }
        File evvPath = SendingUtil.getEvvPath(sending.getSendingId(), true);
        if (!evvPath.exists()) {
            flash.setBad(Services.getText(617) + " " + String.valueOf(evvPath));
            return;
        }
        File eVV = SendingUtil.getEvvPath(sending.getSendingId(), true);
        if (eVV.exists()) {
            AttachmentEntry xmlEntry = NodeFactory.create(AttachmentEntry.class);
            xmlEntry.getAttachmentHandle().setBody(new FileSystemAttachment(eVV, this.getFullFileName(sending, "evv.xml"), true));
            result.add(xmlEntry);
            AttachmentEntry pdfEntry = NodeFactory.create(AttachmentEntry.class);
            pdfEntry.getAttachmentHandle().setBody(new EvvAttachment(evvPath, this.getFullFileName(sending, "evv.pdf")));
            result.add(pdfEntry);
        }
        if ((signatureCheckPath = new File(SendingUtil.getSendingDir(sending.getSendingId(), true), "eVV Signature Check.txt")).exists()) {
            AttachmentEntry checkEntry = NodeFactory.create(AttachmentEntry.class);
            checkEntry.getAttachmentHandle().setBody(new FileSystemAttachment(signatureCheckPath, this.getFullFileName(sending, "eVV Signature Check.txt"), true));
            result.add(checkEntry);
        }
    }

    public void addAdditionalDocuments(Sending sending, Label flash, ListNode<AttachmentEntry> attachments) {
        File sendingPath = SendingUtil.getSendingDir(sending.getSendingId(), true);
        for (File file : sendingPath.listFiles()) {
            if (file.getName().equals(SENDING_FILE) || file.getName().equals("al.pdf") || file.getName().equals("evv.xml") || file.getName().equals("eVV Signature Check.txt")) continue;
            AttachmentEntry entry = NodeFactory.create(AttachmentEntry.class);
            entry.getAttachmentHandle().setBody(new FileSystemAttachment(file, file.getName(), true));
            attachments.add(entry);
        }
    }
}

