/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.pm;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.FileNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.FileSystemAttachment;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.ui.dialog.mail.model.OpenHandle;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.FileChooserUtil;
import java.io.File;

public class AttachmentModel
extends TablePm<AttachmentEntry> {
    private final Label flash;

    public AttachmentModel(ListNode<AttachmentEntry> nodes, Label flash) {
        super(nodes, AttachmentEntry.class, AttachmentEntry.tableConfig);
        this.flash = flash;
    }

    @Override
    protected void addNewLine(boolean addButton) {
        this.flash.reset();
        FileNode lastAttachmendFolder = Services.get(IConfigService.class).getPreferences().getLastUsedFolders().getEmailAttachmentFolder();
        File[] files = FileChooserUtil.chooseFiles(lastAttachmendFolder.getValue(), Services.getText(4213), null, null);
        if (files.length == 0) {
            return;
        }
        lastAttachmendFolder.setValue(files[0].getParentFile());
        Services.get(IConfigService.class).savePreferences();
        for (File file : files) {
            if (!file.exists()) {
                this.flash.setBad(Services.getText(4214) + " " + String.valueOf(file));
                continue;
            }
            AttachmentEntry attachment = NodeFactory.create(AttachmentEntry.class);
            attachment.getAttachmentHandle().setBody(new FileSystemAttachment(file, null, false));
            this.addEntry(attachment);
        }
    }

    @Override
    protected void handleMouseClicked(int row, int col, int clickCount) {
        if (clickCount != 1) {
            return;
        }
        if (col != 2) {
            return;
        }
        OpenHandle handle = (OpenHandle)this.getValueAt(row, 2);
        IAttachmentBody body = handle.getAttachmentHandle().getBody();
        if (body == null) {
            return;
        }
        body.showDocument();
    }
}

