/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.mail.pm;

import ch.transsoft.edec.model.config.conf.mail.MailInfo;
import ch.transsoft.edec.model.config.conf.mail.MailText;
import ch.transsoft.edec.model.config.conf.options.MailOptionInfo;
import ch.transsoft.edec.model.config.pref.mail.MailPreferenceInfo;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.SendMailViaOutlookJob;
import ch.transsoft.edec.service.backend.jobs.SendMailViaSmtpJob;
import ch.transsoft.edec.service.backend.jobs.SendMailViaTransSoftServerJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.ui.dialog.mail.config.IMailDialogConfig;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import ch.transsoft.edec.ui.dialog.mail.pm.AttachmentFactory;
import ch.transsoft.edec.ui.dialog.mail.pm.AttachmentModel;
import ch.transsoft.edec.ui.dialog.mail.pm.MailDialogPmBase;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.util.TextUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MailDialogExportPm
extends MailDialogPmBase {
    private final Sending sending;
    private final IMailDialogConfig config;
    private final MailOptionInfo mailOptionInfo;
    private final MailPreferenceInfo mailPreferenceInfo;
    private final AttachmentModel attachmentModel;
    private final JButton sendButton;
    private final JCheckBox sendCopy;
    private final JTextField toAddress;
    private final JTextField fromAddress;
    private final JTextArea content;
    private final JTextField subject;
    private final JScrollPane contentScrollPane;
    private final ListNode<AttachmentEntry> attachments;
    private ActionBase newAction;
    private ActionBase deleteAction;
    private ActionBase saveAction;
    private JComboBox<MailText> textSelectionCombo;
    private final Label flash = new Label(" ", true);
    private final MailInfo mailInfo;

    public MailDialogExportPm(IMailDialogConfig config) {
        this.config = config;
        this.sending = Services.get(IAppService.class).getCurrentSending();
        this.mailInfo = config.getMailInfo();
        this.mailOptionInfo = Services.get(IConfigService.class).getOptionInfo().getMailOptionInfo();
        this.mailPreferenceInfo = Services.get(IConfigService.class).getPreferences().getMailPreferenceInfo();
        this.attachments = new ListNode<AttachmentEntry>(AttachmentEntry.class);
        AttachmentFactory attachmentFactory = new AttachmentFactory(config.getAddPrefixToFileName());
        if (config.addAl()) {
            attachmentFactory.addAl(this.sending, this.attachments);
        }
        if (config.addForms()) {
            attachmentFactory.addForms(this.sending, this.attachments);
        }
        if (config.addEdecXmlData() && !attachmentFactory.addEdec(this.sending, this.attachments)) {
            this.flash.setBad(String.format(Services.getText(4215), "e-dec_xml.txt"));
        }
        if (config.addSendingXmlData() && this.mailOptionInfo.getAttachSendingXml().getValue().booleanValue()) {
            attachmentFactory.addSendingXml(this.sending, this.attachments);
        }
        if (config.addEvv()) {
            attachmentFactory.addEvv(this.sending, this.flash, this.attachments);
        }
        if (config.addAdditionalDocuments()) {
            attachmentFactory.addAdditionalDocuments(this.sending, this.flash, this.attachments);
        }
        this.attachmentModel = new AttachmentModel(this.attachments, this.flash);
        this.content = new JTextArea();
        this.contentScrollPane = new JScrollPane(this.content);
        this.subject = new JTextField();
        this.sendButton = new JButton(this.getSendMailText());
        this.sendCopy = new JCheckBox(Services.getText(4217));
        this.sendCopy.setSelected(this.mailInfo.getSendCopyToConsignor().getValue());
        this.addSendCopyListener();
        this.toAddress = new JTextField();
        this.toAddress.setBackground(Design.CONTROL_BG_MANDATORY);
        this.fromAddress = new JTextField();
        this.fromAddress.setBackground(Design.CONTROL_BG_MANDATORY);
        this.toAddress.setText(config.getConsigneeMailAddress(this.sending));
        this.fromAddress.setText(this.getDefaultFromAddress());
        this.createActions();
        this.updateDeleteActionEnablement();
        this.createTextSelectionCombo();
    }

    private String getDefaultFromAddress() {
        if (this.mailPreferenceInfo.getSendViaOutlook()) {
            return "";
        }
        if (this.mailPreferenceInfo.getSendViaTransSoftServer()) {
            return this.sending.getConsignorEMail();
        }
        if (this.mailPreferenceInfo.getSendViaSMTP()) {
            return this.mailPreferenceInfo.getSenderEmailAdress().getValue();
        }
        throw new IllegalStateException("Unexpected Mail Strategy");
    }

    private void addSendCopyListener() {
        this.sendCopy.addActionListener(e2 -> {
            this.mailInfo.getSendCopyToConsignor().setValue(this.sendCopy.isSelected());
            this.saveActionPerformed();
        });
    }

    private void createTextSelectionCombo() {
        this.textSelectionCombo = new JComboBox();
        if (this.mailInfo.getMailTexts().isEmpty()) {
            this.mailInfo.getMailTexts().add(this.createDefaultMailText());
        } else {
            for (MailText current : this.mailInfo.getMailTexts()) {
                if (current.getSubject().isInitialized()) continue;
                current.getSubject().setValue(this.config.getSubject());
            }
        }
        String lastSelection = this.mailInfo.getLastSelectedMailText().getValue();
        for (MailText current : this.mailInfo.getMailTexts()) {
            this.textSelectionCombo.addItem(current);
            if (!current.getName().getValue().equals(lastSelection)) continue;
            this.textSelectionCombo.setSelectedItem(current);
        }
        this.setTextToTextArea();
        this.addComboListener();
    }

    private void addComboListener() {
        this.textSelectionCombo.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                MailDialogExportPm.this.handleContentsChanged();
            }
        });
    }

    private void handleContentsChanged() {
        this.setTextToTextArea();
        this.mailInfo.getLastSelectedMailText().setValue(this.getSelectedText().getName().getValue());
        this.config.saveMailInfo(this.mailInfo);
    }

    private void setTextToTextArea() {
        this.content.setText(this.getSelectedText().getText().getValue());
        this.content.setCaretPosition(0);
        this.subject.setText(this.getSubjectText());
    }

    private String getSubjectText() {
        String result = this.getSelectedText().getSubject().getValue();
        if (result.equals(Services.getText(784))) {
            return Services.getText(786);
        }
        return result;
    }

    private MailText createDefaultMailText() {
        MailText result = NodeFactory.create(MailText.class);
        result.getName().setValue(this.config.getTextTitle());
        result.getText().setValue(this.config.createContent(this.sending));
        result.getSubject().setValue(this.config.getSubject());
        return result;
    }

    private void createActions() {
        this.newAction = new ActionBase(Services.getText(4219), "icon/New-small.png", "icon/New-small.png"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MailDialogExportPm.this.newActionPerformed();
            }
        };
        this.newAction.setTooltip(Services.getText(4220));
        this.deleteAction = new ActionBase(Services.getText(4221), "icon/Delete-small.png", "icon/Delete-small.png"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MailDialogExportPm.this.deleteActionPerformed();
            }
        };
        this.deleteAction.setTooltip(Services.getText(4222));
        this.saveAction = new ActionBase(Services.getText(4223), "icon/Save-small.png", "icon/Save-small.png"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MailDialogExportPm.this.saveActionPerformed();
            }
        };
        this.saveAction.setTooltip(Services.getText(4224));
    }

    protected void saveActionPerformed() {
        MailText text = this.getSelectedText();
        text.getText().setValue(this.content.getText());
        text.getSubject().setValue(this.subject.getText());
        this.config.saveMailInfo(this.mailInfo);
    }

    private MailText getSelectedText() {
        return (MailText)this.textSelectionCombo.getSelectedItem();
    }

    protected void deleteActionPerformed() {
        MailText text = this.getSelectedText();
        this.mailInfo.getMailTexts().remove(text);
        this.textSelectionCombo.removeItem(text);
        this.updateDeleteActionEnablement();
    }

    private void updateDeleteActionEnablement() {
        this.deleteAction.setEnabled(this.mailInfo.getMailTexts().size() > 1);
    }

    protected void newActionPerformed() {
        String name = DialogUtil.getInput(Services.getText(4225), Services.getText(4226));
        if (name == null) {
            return;
        }
        MailText text = NodeFactory.create(MailText.class);
        text.getName().setValue(name);
        this.mailInfo.getMailTexts().add(text);
        this.textSelectionCombo.addItem(text);
        this.textSelectionCombo.setSelectedItem(text);
        this.updateDeleteActionEnablement();
    }

    @Override
    public JCheckBox getSendCopy() {
        return this.sendCopy;
    }

    @Override
    public JTextField getToAddressField() {
        return this.toAddress;
    }

    @Override
    public List<String> getToAddress() {
        String noSpaces = this.toAddress.getText().replaceAll(" ", "");
        if (noSpaces.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] addresses = noSpaces.split(";");
        return Arrays.asList(addresses);
    }

    @Override
    public JTextField getFromAddressField() {
        return this.fromAddress;
    }

    @Override
    public String getFromAddress() {
        return this.fromAddress.getText().replaceAll(" ", "");
    }

    @Override
    public AttachmentModel getAttachmentModel() {
        return this.attachmentModel;
    }

    @Override
    public JButton getSendButton() {
        return this.sendButton;
    }

    @Override
    public ListNode<AttachmentEntry> getAttachments() {
        return this.attachments;
    }

    @Override
    public JComponent getContent() {
        return this.contentScrollPane;
    }

    @Override
    public JComponent getSubject() {
        return this.subject;
    }

    @Override
    public CarrierMail getMail() throws Exception {
        CarrierMail result = new CarrierMail();
        result.getToAddresses().addAll(this.getToAddress());
        if (this.sendCopy.isSelected()) {
            result.getCcAddresses().add(this.getFromAddress());
        }
        result.setReplyAddress(this.getFromAddress());
        if (this.mailOptionInfo.getConsignorAsFromAddr().getValue().booleanValue()) {
            result.setFromAddress(this.getFromAddress());
        } else {
            result.setFromAddress("expovit@transsoft.ch");
        }
        result.setSubject(TextUtil.resolveFields(this.sending, this.subject.getText()));
        result.setContent(TextUtil.resolveFields(this.sending, this.content.getText()));
        for (AttachmentEntry attachment : this.getAttachments()) {
            this.addAtachment(result, attachment);
        }
        return result;
    }

    private void addAtachment(CarrierMail result, AttachmentEntry entry) throws Exception {
        CarrierMail.Attachment attachment = new CarrierMail.Attachment();
        IAttachmentBody body = entry.getBody();
        attachment.setFileName(body.getFileName());
        attachment.setMime(body.getMimeType());
        attachment.setData(body.getData(null));
        result.getAttachments().add(attachment);
    }

    @Override
    public void sendMail() throws Exception {
        Boolean copyAttachments = this.mailOptionInfo.getCopyAttachedFilesToSendingFolder().getValue();
        if (this.isSendViaOutlook()) {
            Services.get(IBackendService.class).put(new SendMailViaOutlookJob(this.sending, this.getMail(), this.getAttachments(), this.config.getSendingManip(), copyAttachments));
        } else if (this.isSendViaSMTP()) {
            Services.get(IBackendService.class).put(new SendMailViaSmtpJob(this.sending, this.getMail(), this.getAttachments(), this.config.getSendingManip(), copyAttachments));
        } else {
            Services.get(IBackendService.class).put(new SendMailViaTransSoftServerJob(this.sending, this.getMail(), this.getAttachments(), this.config.getSendingManip(), copyAttachments));
        }
    }

    @Override
    public JComboBox<MailText> getTextSelectionCombo() {
        return this.textSelectionCombo;
    }

    @Override
    public Action getNewAction() {
        return this.newAction;
    }

    @Override
    public Action getDeleteAction() {
        return this.deleteAction;
    }

    @Override
    public Action getSaveAction() {
        return this.saveAction;
    }

    @Override
    public Label getFlash() {
        return this.flash;
    }

    @Override
    public String getHeaderText() {
        return this.config.getHeaderText();
    }

    @Override
    public String getIcon() {
        return this.config.getIcon();
    }

    @Override
    public String getTitle() {
        return this.config.getTitle();
    }

    @Override
    public JComponent getAddButton() {
        return null;
    }
}

