/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.masterdata;

import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.dialog.masterdata.DetailPanelContainer;
import ch.transsoft.edec.ui.dialog.masterdata.IMasterdataPm;
import ch.transsoft.edec.ui.gui.control.table.SortableTable;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.disposable.IDisposable;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class ContentPanel<T extends DataNode<T>, E extends ListEntry<E>>
extends JSplitPane {
    private boolean pendingChanges = false;
    private IDisposable disposable;
    private final T masterData;
    private final DetailPanelContainer<E> detailPanelContainer;

    public ContentPanel(TablePm<E> pm, T masterData, Class<? extends IMasterdataPm> pmType, Class<? extends JComponent> guiType) {
        super(0);
        this.masterData = masterData;
        this.addChangeListener();
        SortableTable<E> table = new SortableTable<E>(pm, 190, pm.getConfig());
        this.setLeftComponent(table);
        this.detailPanelContainer = new DetailPanelContainer(pmType, guiType);
        this.setRightComponent(this.detailPanelContainer);
        pm.addSelectionListener(this.detailPanelContainer);
        table.setFocus(1);
    }

    private void addChangeListener() {
        this.disposable = ((NodeBase)this.masterData).addChangeListener((source, info) -> {
            this.pendingChanges = true;
        });
    }

    public void saveChanges() {
        this.detailPanelContainer.saveChanges();
        Services.get(IDataService.class).saveMasterData(this.masterData);
        this.pendingChanges = false;
    }

    public boolean noPendingChanges() {
        return !this.pendingChanges;
    }

    public void dispose() {
        this.disposable.dispose();
        this.detailPanelContainer.dispose();
    }
}

