/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.dialog.masterdata.goodsitem;

import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.ui.dialog.masterdata.goodsitem.CopyGoodsItemAction;
import ch.transsoft.edec.ui.pm.model.TablePm;
import java.util.List;
import javax.swing.Action;

public class GoodsItemTablePm
extends TablePm<GoodsItem> {
    public GoodsItemTablePm(ListNode<GoodsItem> node) {
        super(node, GoodsItem.class, GoodsItem.masterDatatableConfig);
    }

    @Override
    protected boolean configureEmptyLine(GoodsItem newRow, boolean addButton) {
        if (newRow.getId().isInitialized()) {
            return true;
        }
        newRow.getId().setValue(Long.toString(this.getNextId()));
        return true;
    }

    private long getNextId() {
        long result = 0L;
        for (GoodsItem item : this.getListNode()) {
            if (!item.getId().isInitialized()) continue;
            try {
                result = Math.max(result, Long.parseLong(item.getId().getValue()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result + 1L;
    }

    @Override
    public List<Action> getContextMenu() {
        if (this.getSelectedItem() == null) {
            return super.getContextMenu();
        }
        if (this.isEmptyLine((GoodsItem)this.getSelectedItem())) {
            return super.getContextMenu();
        }
        List<Action> result = super.getContextMenu();
        result.add(new CopyGoodsItemAction(this.getListNode(), (GoodsItem)this.getSelectedItem(), this.getNextId()));
        return result;
    }
}

